/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.query.query;

import com.microsoft.spring.data.gremlin.mapping.GremlinPersistentProperty;
import com.microsoft.spring.data.gremlin.query.GremlinOperations;
import com.microsoft.spring.data.gremlin.query.paramerter.GremlinParameterAccessor;
import com.microsoft.spring.data.gremlin.query.query.AbstractGremlinQuery;
import com.microsoft.spring.data.gremlin.query.query.GremlinQuery;
import com.microsoft.spring.data.gremlin.query.query.GremlinQueryCreator;
import com.microsoft.spring.data.gremlin.query.query.GremlinQueryMethod;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.NonNull;

public class PartTreeGremlinQuery
extends AbstractGremlinQuery {
    private final PartTree partTree;
    private final ResultProcessor processor;
    private final MappingContext<?, GremlinPersistentProperty> mappingContext;

    public PartTreeGremlinQuery(@NonNull GremlinQueryMethod method, @NonNull GremlinOperations operations) {
        super(method, operations);
        this.processor = method.getResultProcessor();
        this.partTree = new PartTree(method.getName(), this.processor.getReturnedType().getDomainType());
        this.mappingContext = operations.getMappingConverter().getMappingContext();
    }

    @Override
    protected GremlinQuery createQuery(@NonNull GremlinParameterAccessor accessor) {
        GremlinQueryCreator creator = new GremlinQueryCreator(this.partTree, accessor, this.mappingContext);
        if (this.partTree.isLimiting()) {
            throw new UnsupportedOperationException("Limitation is not supported yet");
        }
        return (GremlinQuery)creator.createQuery();
    }
}

