/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.repository.support;

import com.microsoft.spring.data.gremlin.annotation.Edge;
import com.microsoft.spring.data.gremlin.annotation.GeneratedValue;
import com.microsoft.spring.data.gremlin.annotation.Graph;
import com.microsoft.spring.data.gremlin.annotation.Vertex;
import com.microsoft.spring.data.gremlin.common.GremlinUtils;
import com.microsoft.spring.data.gremlin.conversion.source.AbstractGremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceEdge;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceGraph;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceVertex;
import com.microsoft.spring.data.gremlin.exception.GremlinInvalidEntityIdFieldException;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedEntityTypeException;
import java.lang.reflect.Field;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public class GremlinEntityInformation<T, ID>
extends AbstractEntityInformation<T, ID> {
    private final Field idField;

    public GremlinEntityInformation(@NonNull Class<T> domainClass) {
        super(domainClass);
        this.idField = this.getIdField(domainClass);
    }

    private GremlinSource<T> createGremlinSource(@NonNull Class<T> domainClass, @NonNull Field idField) {
        String label;
        AbstractGremlinSource source;
        String domainClassName = domainClass.getSimpleName();
        Vertex vertex = domainClass.getAnnotation(Vertex.class);
        Edge edge = domainClass.getAnnotation(Edge.class);
        Graph graph = domainClass.getAnnotation(Graph.class);
        if (vertex != null && edge == null && graph == null) {
            source = new GremlinSourceVertex<T>(domainClass);
            label = vertex.label().isEmpty() ? domainClassName : vertex.label();
        } else if (edge != null && vertex == null && graph == null) {
            source = new GremlinSourceEdge<T>(domainClass);
            label = edge.label().isEmpty() ? domainClassName : edge.label();
        } else if (graph != null && vertex == null && edge == null) {
            source = new GremlinSourceGraph<T>(domainClass);
            label = "";
        } else {
            throw new GremlinUnexpectedEntityTypeException("Unexpected gremlin entity type");
        }
        source.setLabel(label);
        source.setIdField(idField);
        return source;
    }

    public GremlinSource<T> createGremlinSource() {
        return this.createGremlinSource(super.getJavaType(), this.idField);
    }

    @Nullable
    public ID getId(T entity) {
        Field idField = this.idField;
        Object id = ReflectionUtils.getField((Field)idField, entity);
        if (id == null && !super.getJavaType().isAnnotationPresent(Graph.class) && !idField.isAnnotationPresent(GeneratedValue.class)) {
            throw new GremlinInvalidEntityIdFieldException("A non-generated id field cannot be null!");
        }
        return (ID)id;
    }

    public Class<ID> getIdType() {
        Class<?> idClass = this.idField.getType();
        return idClass;
    }

    @NonNull
    private Field getIdField(@NonNull Class<T> domainClass) {
        Field idField = GremlinUtils.getIdField(domainClass);
        ReflectionUtils.makeAccessible((Field)idField);
        return idField;
    }

    public Field getIdField() {
        return this.idField;
    }
}

