/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.conversion.result;

import com.microsoft.spring.data.gremlin.common.GremlinUtils;
import com.microsoft.spring.data.gremlin.conversion.result.AbstractGremlinResultReader;
import com.microsoft.spring.data.gremlin.conversion.result.GremlinResultsReader;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceVertex;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedSourceTypeException;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class GremlinResultVertexReader
extends AbstractGremlinResultReader
implements GremlinResultsReader {
    private void validate(List<Result> results, GremlinSource source) {
        Assert.notNull(results, (String)"Results should not be null.");
        Assert.notNull((Object)source, (String)"GremlinSource should not be null.");
        Assert.isTrue((results.size() == 1 ? 1 : 0) != 0, (String)"Vertex should contain only one result.");
        Result result = results.get(0);
        Assert.isInstanceOf(Map.class, (Object)result.getObject(), (String)"should be one instance of Map");
        Map map = (Map)result.getObject();
        Assert.isTrue((boolean)map.containsKey("id"), (String)"should contain id property");
        Assert.isTrue((boolean)map.containsKey("label"), (String)"should contain label property");
        Assert.isTrue((boolean)map.containsKey("type"), (String)"should contain type property");
        Assert.isTrue((boolean)map.containsKey("properties"), (String)"should contain properties property");
        Assert.isTrue((boolean)map.get("type").equals("vertex"), (String)"must be vertex type");
        Assert.isInstanceOf(Map.class, map.get("properties"), (String)"should be one instance of Map");
    }

    @Override
    public void read(@NonNull List<Result> results, @NonNull GremlinSource source) {
        if (!(source instanceof GremlinSourceVertex)) {
            throw new GremlinUnexpectedSourceTypeException("Should be instance of GremlinSourceVertex");
        }
        this.validate(results, source);
        Map map = (Map)results.get(0).getObject();
        Map properties = (Map)map.get("properties");
        super.readResultProperties(properties, source);
        String className = source.getProperties().get("_classname").toString();
        source.setIdField(GremlinUtils.getIdField(GremlinUtils.toEntityClass(className)));
        source.setId(map.get("id"));
        source.setLabel(map.get("label").toString());
    }
}

