/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.conversion.script;

import com.microsoft.spring.data.gremlin.common.Constants;
import com.microsoft.spring.data.gremlin.common.GremlinEntityType;
import com.microsoft.spring.data.gremlin.conversion.script.AbstractGremlinScriptLiteral;
import com.microsoft.spring.data.gremlin.conversion.script.GremlinScriptLiteral;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceVertex;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedSourceTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.springframework.util.Assert;

public class GremlinScriptLiteralVertex
extends AbstractGremlinScriptLiteral
implements GremlinScriptLiteral {
    @Override
    public List<String> generateInsertScript(@NonNull GremlinSource source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!(source instanceof GremlinSourceVertex)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceVertex");
        }
        ArrayList<String> scriptList = new ArrayList<String>();
        scriptList.add("g");
        scriptList.add(GremlinScriptLiteralVertex.generateAddEntityWithLabel(source.getLabel(), GremlinEntityType.VERTEX));
        source.getId().ifPresent(id -> scriptList.add(GremlinScriptLiteralVertex.generatePropertyWithRequiredId(id)));
        scriptList.addAll(GremlinScriptLiteralVertex.generateProperties(source.getProperties()));
        return GremlinScriptLiteralVertex.completeScript(scriptList);
    }

    @Override
    public List<String> generateDeleteAllScript() {
        return Collections.singletonList(Constants.GREMLIN_SCRIPT_VERTEX_DROP_ALL);
    }

    @Override
    public List<String> generateDeleteAllByClassScript(@NonNull GremlinSource source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!(source instanceof GremlinSourceVertex)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceVertex");
        }
        List<String> scriptList = Arrays.asList("g", "V()", GremlinScriptLiteralVertex.generateHasLabel(source.getLabel()), "drop()");
        return GremlinScriptLiteralVertex.completeScript(scriptList);
    }

    @Override
    public List<String> generateFindByIdScript(@NonNull GremlinSource source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!(source instanceof GremlinSourceVertex)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceVertex");
        }
        Assert.isTrue((boolean)source.getId().isPresent(), (String)"GremlinSource should contain id.");
        List<String> scriptList = Arrays.asList("g", "V()", GremlinScriptLiteralVertex.generateHasId(source.getId().get(), source.getIdField()));
        return GremlinScriptLiteralVertex.completeScript(scriptList);
    }

    @Override
    public List<String> generateUpdateScript(@NonNull GremlinSource source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!(source instanceof GremlinSourceVertex)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceVertex");
        }
        ArrayList<String> scriptList = new ArrayList<String>();
        Assert.isTrue((boolean)source.getId().isPresent(), (String)"GremlinSource should contain id.");
        scriptList.add("g");
        scriptList.add(GremlinScriptLiteralVertex.generateEntityWithRequiredId(source.getId().get(), GremlinEntityType.VERTEX));
        scriptList.addAll(GremlinScriptLiteralVertex.generateProperties(source.getProperties()));
        return GremlinScriptLiteralVertex.completeScript(scriptList);
    }

    @Override
    public List<String> generateFindAllScript(@NonNull GremlinSource source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!(source instanceof GremlinSourceVertex)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceVertex");
        }
        String classname = source.getProperties().get("_classname").toString();
        Assert.notNull((Object)classname, (String)"GremlinSource should contain predefined classname");
        List<String> scriptList = Arrays.asList("g", "V()", GremlinScriptLiteralVertex.generateHasLabel(source.getLabel()), GremlinScriptLiteralVertex.generateHas("_classname", (Object)classname));
        return GremlinScriptLiteralVertex.completeScript(scriptList);
    }

    @Override
    public List<String> generateDeleteByIdScript(@NonNull GremlinSource source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!(source instanceof GremlinSourceVertex)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceVertex");
        }
        Assert.isTrue((boolean)source.getId().isPresent(), (String)"GremlinSource should contain id.");
        List<String> scriptList = Arrays.asList("g", "V()", GremlinScriptLiteralVertex.generateHasId(source.getId().get(), source.getIdField()), "drop()");
        return GremlinScriptLiteralVertex.completeScript(scriptList);
    }

    @Override
    public List<String> generateCountScript(@NonNull GremlinSource source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!(source instanceof GremlinSourceVertex)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceVertex");
        }
        return Collections.singletonList(Constants.GREMLIN_SCRIPT_VERTEX_ALL);
    }
}

