/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.conversion.source;

import com.microsoft.spring.data.gremlin.conversion.MappingGremlinConverter;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceVertex;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceWriter;
import com.microsoft.spring.data.gremlin.exception.GremlinEntityInformationException;
import com.microsoft.spring.data.gremlin.exception.GremlinUnexpectedSourceTypeException;
import com.microsoft.spring.data.gremlin.mapping.GremlinPersistentEntity;
import java.lang.reflect.Field;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.lang.NonNull;

public class GremlinSourceVertexWriter
implements GremlinSourceWriter {
    @Override
    public void write(@NonNull Object domain, @NonNull MappingGremlinConverter converter, @NonNull GremlinSource source) {
        if (!(source instanceof GremlinSourceVertex)) {
            throw new GremlinUnexpectedSourceTypeException("should be the instance of GremlinSourceVertex");
        }
        source.setId(converter.getIdFieldValue(domain));
        GremlinPersistentEntity<?> persistentEntity = converter.getPersistentEntity(domain.getClass());
        ConvertingPropertyAccessor accessor = converter.getPropertyAccessor(domain);
        for (Field field : FieldUtils.getAllFields(domain.getClass())) {
            PersistentProperty property = persistentEntity.getPersistentProperty(field.getName());
            if (property == null || field.getName().equals("id") || field.getAnnotation(Id.class) != null) continue;
            if (field.getName().equals("_classname")) {
                throw new GremlinEntityInformationException("Domain Cannot use pre-defined field name: _classname");
            }
            source.setProperty(field.getName(), accessor.getProperty(property));
        }
    }
}

