/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.spring.data.gremlin.repository.support;

import com.microsoft.spring.data.gremlin.common.GremlinEntityType;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSource;
import com.microsoft.spring.data.gremlin.conversion.source.GremlinSourceGraph;
import com.microsoft.spring.data.gremlin.query.GremlinOperations;
import com.microsoft.spring.data.gremlin.repository.GremlinRepository;
import com.microsoft.spring.data.gremlin.repository.support.GremlinEntityInformation;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.NonNull;

public class SimpleGremlinRepository<T, ID extends Serializable>
implements GremlinRepository<T, ID> {
    private final GremlinEntityInformation<T, ID> information;
    private final GremlinOperations operations;

    public SimpleGremlinRepository(GremlinEntityInformation<T, ID> information, @NonNull ApplicationContext context) {
        this(information, (GremlinOperations)context.getBean(GremlinOperations.class));
    }

    public SimpleGremlinRepository(GremlinEntityInformation<T, ID> information, @NonNull GremlinOperations operations) {
        this.operations = operations;
        this.information = information;
    }

    public <S extends T> S save(@NonNull S domain) {
        GremlinSource<T> source = this.information.createGremlinSource();
        source.setId(this.information.getId(domain));
        return this.operations.save(domain, source);
    }

    public <S extends T> Iterable<S> saveAll(@NonNull Iterable<S> domains) {
        return StreamSupport.stream(domains.spliterator(), true).map(this::save).collect(Collectors.toList());
    }

    public Iterable<T> findAll() {
        GremlinSource<T> source = this.information.createGremlinSource();
        if (source instanceof GremlinSourceGraph) {
            throw new UnsupportedOperationException("findAll of Graph is not supported");
        }
        return this.operations.findAll(source);
    }

    public List<T> findAllById(@NonNull Iterable<ID> ids) {
        return StreamSupport.stream(ids.spliterator(), true).map(this::findById).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Optional<T> findById(@NonNull ID id) {
        T domain = this.operations.findById(id, this.information.createGremlinSource());
        return domain == null ? Optional.empty() : Optional.of(domain);
    }

    @Override
    public Iterable<T> findAll(@NonNull Class<T> domainClass) {
        return this.findAll();
    }

    @Override
    public long vertexCount() {
        return this.operations.vertexCount();
    }

    @Override
    public long edgeCount() {
        return this.operations.edgeCount();
    }

    public long count() {
        return this.vertexCount() + this.edgeCount();
    }

    public void delete(@NonNull T domain) {
        this.operations.deleteById(this.information.getId(domain), this.information.createGremlinSource());
    }

    public void deleteById(@NonNull ID id) {
        this.operations.deleteById(id, this.information.createGremlinSource());
    }

    public void deleteAll() {
        this.operations.deleteAll();
    }

    @Override
    public void deleteAll(GremlinEntityType type) {
        this.operations.deleteAll(type);
    }

    @Override
    public void deleteAll(@NonNull Iterable<? extends T> domains) {
        domains.forEach(this::delete);
    }

    @Override
    public void deleteAll(@NonNull Class<T> domainClass) {
        this.operations.deleteAll(this.information.createGremlinSource());
    }

    public boolean existsById(@NonNull ID id) {
        return this.operations.existsById(id, this.information.createGremlinSource());
    }
}

