/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.msi;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

class HttpHelper {
    HttpHelper() {
    }

    static String executeHttpGet(String url, Map<String, String> headers, SSLSocketFactory sslSocketFactory) throws Exception {
        HttpURLConnection conn = HttpHelper.openConnection(url, sslSocketFactory);
        return HttpHelper.executeGetRequest(headers, conn);
    }

    static HttpURLConnection openConnection(URL finalURL, SSLSocketFactory sslSocketFactory) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)finalURL.openConnection();
        if (sslSocketFactory != null && finalURL.getHost().startsWith("https")) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(sslSocketFactory);
        }
        return connection;
    }

    static HttpURLConnection openConnection(String url, SSLSocketFactory sslSocketFactory) throws IOException {
        return HttpHelper.openConnection(new URL(url), sslSocketFactory);
    }

    static HttpURLConnection configureAdditionalHeaders(HttpURLConnection conn, Map<String, String> headers) throws IOException {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    private static String executeGetRequest(Map<String, String> headers, HttpURLConnection conn) throws IOException {
        HttpHelper.configureAdditionalHeaders(conn, headers);
        return HttpHelper.getResponse(headers, conn);
    }

    private static String getResponse(Map<String, String> headers, HttpURLConnection conn) throws IOException {
        String response = HttpHelper.readResponseFromConnection(conn);
        return response;
    }

    static String inputStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    static String readResponseFromConnection(HttpURLConnection conn) throws IOException {
        try (InputStream is = null;){
            if (conn.getResponseCode() != 200) {
                String msg = "Server returned HTTP response code: " + conn.getResponseCode() + " for URL : " + conn.getURL();
                is = conn.getErrorStream();
                if (is != null) {
                    msg = msg + ", Error details : " + HttpHelper.inputStreamToString(is);
                }
                throw new IOException(msg);
            }
            is = conn.getInputStream();
            String string = HttpHelper.inputStreamToString(is);
            return string;
        }
    }
}

