/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.msi;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.microsoft.sqlserver.jdbc.StringUtils;
import com.microsoft.sqlserver.msi.HttpHelper;
import com.microsoft.sqlserver.msi.MsiAuthResponse;
import com.microsoft.sqlserver.msi.MsiTokenCache;
import com.microsoft.sqlserver.msi.NoMSIFoundException;
import com.nimbusds.jose.JWSObject;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.HashMap;
import net.minidev.json.JSONObject;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MsiAuthToken {
    public static final String API_VERSION = "2017-09-01";
    public static final String MSI_ENDPOINT = "MSI_ENDPOINT";
    public static final String MSI_SECRET = "MSI_SECRET";
    protected static final Logger logger = LogManager.getLogger(MsiAuthToken.class);

    public static String aquireMsiToken(String resourceURI) throws Exception {
        String endpoint = System.getenv(MSI_ENDPOINT);
        String secret = System.getenv(MSI_SECRET);
        if (endpoint == null || endpoint.isEmpty()) {
            logger.error((Object)"NO MSI_ENDPOINT FOUND");
            throw new NoMSIFoundException("NO MSI_ENDPOINT FOUND");
        }
        if (secret == null || secret.isEmpty()) {
            logger.error((Object)"NO MSI_SECRET FOUND");
            throw new NoMSIFoundException("NO MSI_SECRET FOUND");
        }
        String tokenUrl = endpoint + "?resource=" + resourceURI + "&api-version=" + API_VERSION;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Secret", secret);
        headers.put("Accept", "application/json, text/javascript, */*");
        MsiAuthResponse response = null;
        try {
            logger.debug((Object)("Invoking endpoint to get token: " + tokenUrl));
            String json = HttpHelper.executeHttpGet(tokenUrl, headers, null);
            response = MsiAuthToken.convertJsonToObject(json, MsiAuthResponse.class);
            logger.debug((Object)("MSI Access Token Expiration: " + response.getExpiresOn()));
        }
        catch (Exception ex) {
            logger.error((Object)"Error Getting MSI token", (Throwable)ex);
            throw ex;
        }
        return response.getAccessToken();
    }

    public static <T> T convertJsonToObject(String json, Class<T> clazz) throws JsonSyntaxException, JsonIOException {
        StringReader reader = new StringReader(json);
        Gson gson = new GsonBuilder().create();
        return (T)gson.fromJson((Reader)reader, clazz);
    }

    public static long getTokenExpiration(String token) throws Exception {
        try {
            JWSObject jwsObject = JWSObject.parse((String)token);
            JSONObject json = jwsObject.getPayload().toJSONObject();
            boolean hasExpiration = json.containsKey((Object)"exp");
            if (hasExpiration) {
                Long ltime = (Long)json.get((Object)"exp");
                logger.debug((Object)("Parsed access token, expiration:" + ltime));
                return ltime;
            }
        }
        catch (ParseException e) {
            logger.error((Object)("Error parsing access token:" + e.getMessage()));
            throw e;
        }
        return 0L;
    }

    public static boolean isMsiEnabled(String jdbcUrl) {
        String msiEnableEnv = System.getenv("JDBC_MSI_ENABLE");
        if (!StringUtils.isEmpty((CharSequence)msiEnableEnv) && msiEnableEnv.compareToIgnoreCase("true") == 0) {
            logger.debug((Object)"MSI Enabled in Environement");
            return true;
        }
        msiEnableEnv = System.getenv("APPSETTING_JDBC_MSI_ENABLE");
        if (!StringUtils.isEmpty((CharSequence)msiEnableEnv) && msiEnableEnv.compareToIgnoreCase("true") == 0) {
            logger.debug((Object)"MSI Enabled in AppSetting Environement");
            return true;
        }
        if (jdbcUrl != null && (jdbcUrl = jdbcUrl.replaceAll("\\s+", "")).indexOf("msiEnable=true") > 0) {
            logger.debug((Object)"MSI Enabled in Url reference");
            return true;
        }
        return false;
    }

    static void cacheToken(String accessToken) throws Exception {
        logger.debug((Object)"Caching Token and expiration");
        MsiTokenCache.saveExpiration(MsiAuthToken.getTokenExpiration(accessToken));
        MsiTokenCache.saveToken(accessToken);
    }
}

