/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.msi;

import com.microsoft.sqlserver.msi.MsiAuthToken;
import com.microsoft.sqlserver.msi.MsiTokenCache;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.JdbcInterceptor;
import org.apache.tomcat.jdbc.pool.PooledConnection;

public class MsiTokenInterceptor
extends JdbcInterceptor {
    protected static final Logger logger = LogManager.getLogger(MsiTokenInterceptor.class);
    protected static long SKEW = 1L;

    public void reset(ConnectionPool parent, PooledConnection con) {
        logger.debug((Object)"Reset connection pool started");
        if (parent == null || con == null) {
            return;
        }
        try {
            if (!MsiAuthToken.isMsiEnabled(parent.getPoolProperties().getUrl())) {
                return;
            }
            long now = System.currentTimeMillis() / 1000L;
            logger.debug((Object)("MSI Token validation time now:" + now + " token expiration at:" + MsiTokenCache.getExpiration()));
            if (MsiTokenCache.getExpiration() > now + SKEW) {
                logger.debug((Object)"Token is still valid");
            } else {
                logger.debug((Object)"Getting new token");
                String accessToken = MsiAuthToken.aquireMsiToken("https://database.windows.net/");
                parent.getPoolProperties().getDbProperties().setProperty("accessToken", accessToken);
                MsiAuthToken.cacheToken(accessToken);
                con.connect();
            }
        }
        catch (Throwable e) {
            logger.error((Object)("Exception caught on reconnect:" + e.getMessage()));
            throw new RuntimeException(e.getCause());
        }
    }

    public void poolStarted(ConnectionPool pool) {
        logger.info((Object)"Init connection pool start");
        super.poolStarted(pool);
        try {
            if (pool != null && MsiAuthToken.isMsiEnabled(pool.getPoolProperties().getUrl())) {
                String accessToken = MsiAuthToken.aquireMsiToken("https://database.windows.net/");
                pool.getPoolProperties().getDbProperties().setProperty("accessToken", accessToken);
                MsiAuthToken.cacheToken(accessToken);
            }
        }
        catch (Throwable e) {
            logger.error((Object)("Exception caught during initialization:" + e.getMessage()));
            throw new RuntimeException(e.getCause());
        }
    }
}

