/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.msi;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;

public class MsiTokenCache {
    private static String KEY_EXPIRE = "expiresOn";
    private static String KEY_TOKEN = "accessToken";
    private static ConcurrentHashMap<String, Object> cache = null;

    protected static ConcurrentHashMap<String, Object> getCache() {
        if (cache == null) {
            cache = new ConcurrentHashMap();
        }
        return cache;
    }

    public static long getExpiration() {
        cache = MsiTokenCache.getCache();
        Long expiration = (Long)cache.get(KEY_EXPIRE);
        if (expiration != null) {
            return expiration;
        }
        return 0L;
    }

    public static String getToken() {
        cache = MsiTokenCache.getCache();
        return (String)cache.get(KEY_TOKEN);
    }

    public static void saveExpiration(String expiration) throws Exception {
        try {
            Date dateFmt = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a X").parse(expiration);
            long expLong = dateFmt.getTime() / 1000L;
            MsiTokenCache.saveExpiration(expLong);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void saveExpiration(long expiration) {
        cache = MsiTokenCache.getCache();
        cache.put(KEY_EXPIRE, new Long(expiration));
    }

    public static void saveToken(String token) {
        cache = MsiTokenCache.getCache();
        cache.put(KEY_TOKEN, token);
    }
}

