/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ExtendedSocketOptions;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerConnection43;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSChannel;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketOption;
import java.sql.BatchUpdateException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DriverJDBCVersion {
    static final int major = 4;
    static final int minor = 3;
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.DriverJDBCVersion");
    private static double jvmVersion = Double.parseDouble(Util.SYSTEM_SPEC_VERSION);
    private static int pid = 0;

    DriverJDBCVersion() {
    }

    static final boolean checkSupportsJDBC43() {
        return true;
    }

    static final void throwBatchUpdateException(SQLServerException lastError, long[] updateCounts) throws BatchUpdateException {
        throw new BatchUpdateException(lastError.getMessage(), lastError.getSQLState(), lastError.getErrorCode(), updateCounts, new Throwable(lastError.getMessage()));
    }

    static SQLServerConnection getSQLServerConnection(String parentInfo) throws SQLServerException {
        return jvmVersion >= 9.0 ? new SQLServerConnection43(parentInfo) : new SQLServerConnection(parentInfo);
    }

    static int getProcessId() {
        return pid;
    }

    static void setSocketOptions(Socket tcpSocket, TDSChannel channel) throws IOException {
        Set<SocketOption<?>> options = tcpSocket.supportedOptions();
        if (options.contains(ExtendedSocketOptions.TCP_KEEPIDLE) && options.contains(ExtendedSocketOptions.TCP_KEEPINTERVAL)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(channel.toString() + ": Setting KeepAlive extended socket options.");
            }
            tcpSocket.setOption(ExtendedSocketOptions.TCP_KEEPIDLE, 30);
            tcpSocket.setOption(ExtendedSocketOptions.TCP_KEEPINTERVAL, 1);
        } else if (logger.isLoggable(Level.FINER)) {
            logger.finer(channel.toString() + ": KeepAlive extended socket options not supported on this platform.");
        }
    }

    static {
        long pidLong = 0L;
        try {
            pidLong = ProcessHandle.current().pid();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        pid = pidLong > Integer.MAX_VALUE ? 0 : (int)pidLong;
    }
}

