/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.security.Key;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

final class SecureStringUtil {
    static final String CIPHER_TRANSFORMATION = "AES/GCM/NoPadding";
    static final String KEYGEN_ALGORITHEM = "AES";
    static final int IV_LENGTH = 12;
    static final int KEY_SIZE = 256;
    static final int TAG_LENGTH = 16;
    byte[] iv = new byte[12];
    SecretKeySpec secretKey;
    private Cipher encryptCipher;
    private Cipher decryptCipher;
    private static SecureStringUtil instance;

    static SecureStringUtil getInstance() throws SQLServerException {
        if (instance == null) {
            instance = new SecureStringUtil();
        }
        return instance;
    }

    private SecureStringUtil() throws SQLServerException {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(KEYGEN_ALGORITHEM);
            keygen.init(256);
            this.secretKey = new SecretKeySpec(keygen.generateKey().getEncoded(), KEYGEN_ALGORITHEM);
            this.encryptCipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            this.decryptCipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
        }
        catch (Exception e) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_SecureStringInitFailed"));
            Object[] msgArgs = new Object[]{e.getMessage()};
            throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
        }
    }

    String getEncryptedString(String str) throws SQLServerException {
        SecureRandom random = new SecureRandom();
        random.nextBytes(this.iv);
        GCMParameterSpec ivParamSpec = new GCMParameterSpec(128, this.iv);
        try {
            this.encryptCipher.init(1, (Key)this.secretKey, ivParamSpec);
            byte[] cipherText = this.encryptCipher.doFinal(str.getBytes());
            return Base64.getEncoder().encodeToString(cipherText);
        }
        catch (Exception e) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_EncryptionFailed"));
            Object[] msgArgs = new Object[]{e.getMessage()};
            throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
        }
    }

    String getDecryptedString(String str) throws SQLServerException {
        GCMParameterSpec ivParamSpec = new GCMParameterSpec(128, this.iv);
        try {
            this.decryptCipher.init(2, (Key)this.secretKey, ivParamSpec);
            byte[] plainText = this.decryptCipher.doFinal(Base64.getDecoder().decode(str));
            return new String(plainText);
        }
        catch (Exception e) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_DecryptionFailed"));
            Object[] msgArgs = new Object[]{e.getMessage()};
            throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
        }
    }
}

