/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.ConfigurableRetryRule;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurableRetryLogic {
    private static final int INTERVAL_BETWEEN_READS_IN_MS = 30000;
    private static final String DEFAULT_PROPS_FILE = "mssql-jdbc.properties";
    private static final Lock CRL_LOCK = new ReentrantLock();
    private static final Logger CONFIGURABLE_RETRY_LOGGER = Logger.getLogger("com.microsoft.sqlserver.jdbc.ConfigurableRetryLogic");
    private static final String SEMI_COLON = ";";
    private static final String COMMA = ",";
    private static final String EQUALS_SIGN = "=";
    private static final String FORWARD_SLASH = "/";
    private static final String RETRY_EXEC = "retryExec";
    private static final String RETRY_CONN = "retryConn";
    private static final String STATEMENT = "statement";
    private static final String CLASS_FILES_SUFFIX = "target/classes/";
    private static boolean replaceFlag = false;
    private static final AtomicLong timeLastModified = new AtomicLong(0L);
    private static final AtomicLong timeLastRead = new AtomicLong(0L);
    private static final AtomicReference<String> lastQuery = new AtomicReference<String>("");
    private static final AtomicReference<String> prevStmtRulesFromConnString = new AtomicReference<String>("");
    private static final AtomicReference<String> prevConnRulesFromConnString = new AtomicReference<String>("");
    private static final AtomicReference<HashMap<Integer, ConfigurableRetryRule>> stmtRules = new AtomicReference(new HashMap());
    private static final AtomicReference<HashMap<Integer, ConfigurableRetryRule>> connRules = new AtomicReference(new HashMap());
    private static ConfigurableRetryLogic singleInstance;

    private ConfigurableRetryLogic() throws SQLServerException {
        timeLastRead.compareAndSet(0L, new Date().getTime());
        ConfigurableRetryLogic.setUpStatementRules(null);
        ConfigurableRetryLogic.setUpConnectionRules(null);
    }

    public static ConfigurableRetryLogic getInstance() throws SQLServerException {
        if (singleInstance == null) {
            CRL_LOCK.lock();
            try {
                if (singleInstance == null) {
                    singleInstance = new ConfigurableRetryLogic();
                }
                ConfigurableRetryLogic.refreshRuleSet();
            }
            finally {
                CRL_LOCK.unlock();
            }
        } else {
            ConfigurableRetryLogic.refreshRuleSet();
        }
        return singleInstance;
    }

    private static void refreshRuleSet() throws SQLServerException {
        long currentTime = new Date().getTime();
        if (currentTime - timeLastRead.get() >= 30000L) {
            timeLastRead.set(currentTime);
            if (timeLastModified.get() != 0L) {
                File f = new File(ConfigurableRetryLogic.getCurrentClassPath());
                if (f.lastModified() != timeLastModified.get()) {
                    ConfigurableRetryLogic.setUpStatementRules(null);
                    ConfigurableRetryLogic.setUpConnectionRules(null);
                }
            } else {
                ConfigurableRetryLogic.setUpStatementRules(prevStmtRulesFromConnString.get());
                ConfigurableRetryLogic.setUpConnectionRules(prevConnRulesFromConnString.get());
            }
        }
    }

    void setStatementRulesFromConnectionString(String newRules) throws SQLServerException {
        prevStmtRulesFromConnString.set(newRules);
        ConfigurableRetryLogic.setUpStatementRules(prevStmtRulesFromConnString.get());
    }

    void setConnectionRulesFromConnectionString(String newRules) throws SQLServerException {
        prevConnRulesFromConnString.set(newRules);
        ConfigurableRetryLogic.setUpConnectionRules(prevConnRulesFromConnString.get());
    }

    void storeLastQuery(String newQueryToStore) {
        lastQuery.set(newQueryToStore.toLowerCase());
    }

    String getLastQuery() {
        return lastQuery.get();
    }

    private static void setUpStatementRules(String cxnStrRules) throws SQLServerException {
        LinkedList<String> temp;
        stmtRules.set(new HashMap());
        lastQuery.set("");
        if (cxnStrRules == null || cxnStrRules.isEmpty()) {
            temp = ConfigurableRetryLogic.readFromFile(RETRY_EXEC);
        } else {
            temp = new LinkedList();
            Collections.addAll(temp, cxnStrRules.split(SEMI_COLON));
        }
        ConfigurableRetryLogic.createStatementRules(temp);
    }

    private static void setUpConnectionRules(String cxnStrRules) throws SQLServerException {
        LinkedList<String> temp;
        connRules.set(new HashMap());
        lastQuery.set("");
        if (cxnStrRules == null || cxnStrRules.isEmpty()) {
            temp = ConfigurableRetryLogic.readFromFile(RETRY_CONN);
        } else {
            temp = new LinkedList();
            Collections.addAll(temp, cxnStrRules.split(SEMI_COLON));
        }
        ConfigurableRetryLogic.createConnectionRules(temp);
    }

    private static void createStatementRules(LinkedList<String> listOfRules) throws SQLServerException {
        stmtRules.set(new HashMap());
        for (String potentialRule : listOfRules) {
            ConfigurableRetryRule rule = new ConfigurableRetryRule(potentialRule);
            if (rule.getError().contains(COMMA)) {
                String[] arr;
                for (String retryError : arr = rule.getError().split(COMMA)) {
                    ConfigurableRetryRule splitRule = new ConfigurableRetryRule(retryError, rule);
                    stmtRules.get().put(Integer.parseInt(splitRule.getError()), splitRule);
                }
                continue;
            }
            stmtRules.get().put(Integer.parseInt(rule.getError()), rule);
        }
    }

    private static void createConnectionRules(LinkedList<String> listOfRules) throws SQLServerException {
        connRules.set(new HashMap());
        replaceFlag = false;
        for (String potentialRule : listOfRules) {
            ConfigurableRetryRule rule = new ConfigurableRetryRule(potentialRule);
            if (rule.replaceExisting) {
                replaceFlag = true;
            }
            if (rule.getError().contains(COMMA)) {
                String[] arr;
                for (String retryError : arr = rule.getError().split(COMMA)) {
                    ConfigurableRetryRule splitRule = new ConfigurableRetryRule(retryError, rule);
                    connRules.get().put(Integer.parseInt(splitRule.getError()), splitRule);
                }
                continue;
            }
            connRules.get().put(Integer.parseInt(rule.getError()), rule);
        }
    }

    private static String getCurrentClassPath() throws SQLServerException {
        String location = "";
        String className = "";
        String uriToString = "";
        try {
            className = new Object(){}.getClass().getEnclosingClass().getName();
            location = Class.forName(className).getProtectionDomain().getCodeSource().getLocation().getPath();
            URI uri = ConfigurableRetryLogic.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            uriToString = uri.toString();
            int initialIndexOfForwardSlash = uriToString.indexOf(FORWARD_SLASH);
            if (!uri.getScheme().isEmpty() && initialIndexOfForwardSlash > 0) {
                uriToString = uriToString.substring(initialIndexOfForwardSlash + 1);
            }
            if (Files.isDirectory(Paths.get(uriToString, new String[0]), new LinkOption[0])) {
                location = location.substring(0, location.length() - CLASS_FILES_SUFFIX.length());
            }
            return new URI(location).getPath() + DEFAULT_PROPS_FILE;
        }
        catch (InvalidPathException e) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_PathInvalid"));
            Object[] msgArgs = new Object[]{uriToString};
            throw new SQLServerException(form.format(msgArgs), null, 0, (Throwable)e);
        }
        catch (URISyntaxException e) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_URLInvalid"));
            Object[] msgArgs = new Object[]{location};
            throw new SQLServerException(form.format(msgArgs), null, 0, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_UnableToFindClass"));
            Object[] msgArgs = new Object[]{className};
            throw new SQLServerException(form.format(msgArgs), null, 0, (Throwable)e);
        }
    }

    private static LinkedList<String> readFromFile(String connectionStringProperty) throws SQLServerException {
        String filePath = ConfigurableRetryLogic.getCurrentClassPath();
        LinkedList<String> list = new LinkedList<String>();
        try {
            File f = new File(filePath);
            try (BufferedReader buffer = new BufferedReader(new FileReader(f));){
                String readLine;
                while ((readLine = buffer.readLine()) != null) {
                    if (!readLine.startsWith(connectionStringProperty)) continue;
                    String value = readLine.split(EQUALS_SIGN)[1];
                    Collections.addAll(list, value.split(SEMI_COLON));
                }
            }
            timeLastModified.set(f.lastModified());
        }
        catch (FileNotFoundException e) {
            if (CONFIGURABLE_RETRY_LOGGER.isLoggable(Level.FINER)) {
                CONFIGURABLE_RETRY_LOGGER.finest("File not found at path - \"" + filePath + "\"");
            }
        }
        catch (IOException e) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
            Object[] msgArgs = new Object[]{e.getMessage() + ", from path - \"" + filePath + "\""};
            throw new SQLServerException(form.format(msgArgs), null, 0, (Throwable)e);
        }
        return list;
    }

    ConfigurableRetryRule searchRuleSet(int ruleToSearchFor, String ruleSet) throws SQLServerException {
        ConfigurableRetryLogic.refreshRuleSet();
        if (ruleSet.equals(STATEMENT)) {
            for (Map.Entry<Integer, ConfigurableRetryRule> entry : stmtRules.get().entrySet()) {
                if (entry.getKey() != ruleToSearchFor) continue;
                return entry.getValue();
            }
        } else {
            for (Map.Entry<Integer, ConfigurableRetryRule> entry : connRules.get().entrySet()) {
                if (entry.getKey() != ruleToSearchFor) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    boolean getReplaceFlag() {
        return replaceFlag;
    }
}

