/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriverStringProperty;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSPIAuthentication;
import com.microsoft.sqlserver.jdbc.Util;
import java.net.IDN;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

final class KerbAuthentication
extends SSPIAuthentication {
    private static final String CONFIGNAME = "SQLJDBCDriver";
    private static final Logger authLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.KerbAuthentication");
    private final SQLServerConnection con;
    private final String spn;
    private final GSSManager manager = GSSManager.getInstance();
    private LoginContext lc = null;
    private GSSCredential peerCredentials = null;
    private GSSContext peerContext = null;

    private void intAuthInit() throws SQLServerException {
        block9: {
            try {
                Oid kerberos = new Oid("1.2.840.113554.1.2.2");
                GSSName remotePeerName = this.manager.createName(this.spn, null);
                if (null != this.peerCredentials) {
                    this.peerContext = this.manager.createContext(remotePeerName, kerberos, this.peerCredentials, 0);
                    this.peerContext.requestCredDeleg(false);
                    this.peerContext.requestMutualAuth(true);
                    this.peerContext.requestInteg(true);
                    break block9;
                }
                Subject currentSubject = null;
                try {
                    AccessControlContext context = AccessController.getContext();
                    currentSubject = Subject.getSubject(context);
                    if (null == currentSubject) {
                        this.lc = new LoginContext(CONFIGNAME);
                        this.lc.login();
                        currentSubject = this.lc.getSubject();
                    }
                }
                catch (LoginException le) {
                    this.con.terminate(0, SQLServerException.getErrString("R_integratedAuthenticationFailed"), le);
                }
                if (authLogger.isLoggable(Level.FINER)) {
                    authLogger.finer(this.toString() + " Getting client credentials");
                }
                this.peerCredentials = KerbAuthentication.getClientCredential(currentSubject, this.manager, kerberos);
                if (authLogger.isLoggable(Level.FINER)) {
                    authLogger.finer(this.toString() + " creating security context");
                }
                this.peerContext = this.manager.createContext(remotePeerName, kerberos, this.peerCredentials, 0);
                this.peerContext.requestCredDeleg(true);
                this.peerContext.requestMutualAuth(true);
                this.peerContext.requestInteg(true);
            }
            catch (GSSException ge) {
                authLogger.finer(this.toString() + "initAuthInit failed GSSException:-" + ge);
                this.con.terminate(0, SQLServerException.getErrString("R_integratedAuthenticationFailed"), ge);
            }
            catch (PrivilegedActionException ge) {
                authLogger.finer(this.toString() + "initAuthInit failed privileged exception:-" + ge);
                this.con.terminate(0, SQLServerException.getErrString("R_integratedAuthenticationFailed"), ge);
            }
        }
    }

    private static GSSCredential getClientCredential(Subject subject, final GSSManager MANAGER, final Oid kerboid) throws PrivilegedActionException {
        PrivilegedExceptionAction<GSSCredential> action = new PrivilegedExceptionAction<GSSCredential>(){

            @Override
            public GSSCredential run() throws GSSException {
                return MANAGER.createCredential(null, 0, kerboid, 1);
            }
        };
        GSSCredential credential = Subject.doAs(subject, action);
        return credential;
    }

    private byte[] intAuthHandShake(byte[] pin, boolean[] done) throws SQLServerException {
        try {
            if (authLogger.isLoggable(Level.FINER)) {
                authLogger.finer(this.toString() + " Sending token to server over secure context");
            }
            byte[] byteToken = this.peerContext.initSecContext(pin, 0, pin.length);
            if (this.peerContext.isEstablished()) {
                done[0] = true;
                if (authLogger.isLoggable(Level.FINER)) {
                    authLogger.finer(this.toString() + "Authentication done.");
                }
            } else if (null == byteToken) {
                authLogger.info(this.toString() + "byteToken is null in initSecContext.");
                this.con.terminate(0, SQLServerException.getErrString("R_integratedAuthenticationFailed"));
            }
            return byteToken;
        }
        catch (GSSException ge) {
            authLogger.finer(this.toString() + "initSecContext Failed :-" + ge);
            this.con.terminate(0, SQLServerException.getErrString("R_integratedAuthenticationFailed"), ge);
            return null;
        }
    }

    private String makeSpn(String server, int port) throws SQLServerException {
        if (authLogger.isLoggable(Level.FINER)) {
            authLogger.finer(this.toString() + " Server: " + server + " port: " + port);
        }
        StringBuilder spn = new StringBuilder("MSSQLSvc/");
        if (this.con.serverNameAsACE()) {
            spn.append(IDN.toASCII(server));
        } else {
            spn.append(server);
        }
        spn.append(":");
        spn.append(port);
        String strSPN = spn.toString();
        if (authLogger.isLoggable(Level.FINER)) {
            authLogger.finer(this.toString() + " SPN: " + strSPN);
        }
        return strSPN;
    }

    KerbAuthentication(SQLServerConnection con, String address, int port) throws SQLServerException {
        this.con = con;
        String userSuppliedServerSpn = con.activeConnectionProperties.getProperty(SQLServerDriverStringProperty.SERVER_SPN.toString());
        if (null != userSuppliedServerSpn) {
            if (con.serverNameAsACE()) {
                int slashPos = userSuppliedServerSpn.indexOf("/");
                this.spn = userSuppliedServerSpn.substring(0, slashPos + 1) + IDN.toASCII(userSuppliedServerSpn.substring(slashPos + 1));
            } else {
                this.spn = userSuppliedServerSpn;
            }
        } else {
            this.spn = this.makeSpn(address, port);
        }
    }

    KerbAuthentication(SQLServerConnection con, String address, int port, GSSCredential ImpersonatedUserCred) throws SQLServerException {
        this(con, address, port);
        this.peerCredentials = ImpersonatedUserCred;
    }

    @Override
    byte[] GenerateClientContext(byte[] pin, boolean[] done) throws SQLServerException {
        if (null == this.peerContext) {
            this.intAuthInit();
        }
        return this.intAuthHandShake(pin, done);
    }

    @Override
    int ReleaseClientContext() throws SQLServerException {
        try {
            if (null != this.peerCredentials) {
                this.peerCredentials.dispose();
            }
            if (null != this.peerContext) {
                this.peerContext.dispose();
            }
            if (null != this.lc) {
                this.lc.logout();
            }
        }
        catch (LoginException e) {
            authLogger.fine(this.toString() + " Release of the credentials failed LoginException: " + e);
        }
        catch (GSSException e) {
            authLogger.fine(this.toString() + " Release of the credentials failed GSSException: " + e);
        }
        return 0;
    }

    static {
        class SQLJDBCDriverConfig
        extends Configuration {
            Configuration current = null;
            AppConfigurationEntry[] driverConf;

            SQLJDBCDriverConfig() {
                try {
                    this.current = Configuration.getConfiguration();
                }
                catch (SecurityException e) {
                    authLogger.finer(this.toString() + " No configurations provided, setting driver default");
                }
                AppConfigurationEntry[] config = null;
                if (null != this.current) {
                    config = this.current.getAppConfigurationEntry(KerbAuthentication.CONFIGNAME);
                }
                if (null == config) {
                    AppConfigurationEntry appConf;
                    if (authLogger.isLoggable(Level.FINER)) {
                        authLogger.finer(this.toString() + " SQLJDBCDriver configuration entry is not provided, setting driver default");
                    }
                    if (Util.isIBM()) {
                        HashMap<String, String> confDetails = new HashMap<String, String>();
                        confDetails.put("useDefaultCcache", "true");
                        confDetails.put("moduleBanner", "false");
                        appConf = new AppConfigurationEntry("com.ibm.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, confDetails);
                        if (authLogger.isLoggable(Level.FINER)) {
                            authLogger.finer(this.toString() + " Setting IBM Krb5LoginModule");
                        }
                    } else {
                        HashMap<String, String> confDetails = new HashMap<String, String>();
                        confDetails.put("useTicketCache", "true");
                        confDetails.put("doNotPrompt", "true");
                        appConf = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, confDetails);
                        if (authLogger.isLoggable(Level.FINER)) {
                            authLogger.finer(this.toString() + " Setting Sun Krb5LoginModule");
                        }
                    }
                    this.driverConf = new AppConfigurationEntry[1];
                    this.driverConf[0] = appConf;
                    Configuration.setConfiguration(this);
                }
            }

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                if (name.equals(KerbAuthentication.CONFIGNAME)) {
                    return this.driverConf;
                }
                if (null != this.current) {
                    return this.current.getAppConfigurationEntry(name);
                }
                return null;
            }

            @Override
            public void refresh() {
                if (null != this.current) {
                    this.current.refresh();
                }
            }
        }
        SQLJDBCDriverConfig sQLJDBCDriverConfig = new SQLJDBCDriverConfig();
    }
}

