/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IntegratedWindowsAuthenticationParameters;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.UserNamePasswordParameters;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SqlFedAuthToken;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.kerberos.KerberosPrincipal;

class SQLServerMSAL4JUtils {
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerMSAL4JUtils");

    SQLServerMSAL4JUtils() {
    }

    static SqlFedAuthToken getSqlFedAuthToken(SQLServerConnection.SqlFedAuthInfo fedAuthInfo, String user, String password, String authenticationString) throws SQLServerException {
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        try {
            PublicClientApplication clientApplication = ((PublicClientApplication.Builder)((PublicClientApplication.Builder)PublicClientApplication.builder((String)"7f98cb04-cd1e-40df-9140-3bf7e2cea4db").executorService(executorService)).authority(fedAuthInfo.stsurl)).build();
            CompletableFuture future = clientApplication.acquireToken(UserNamePasswordParameters.builder(Collections.singleton(fedAuthInfo.spn + "/.default"), (String)user, (char[])password.toCharArray()).build());
            IAuthenticationResult authenticationResult = (IAuthenticationResult)future.get();
            SqlFedAuthToken sqlFedAuthToken = new SqlFedAuthToken(authenticationResult.accessToken(), authenticationResult.expiresOnDate());
            return sqlFedAuthToken;
        }
        catch (InterruptedException | MalformedURLException e) {
            throw new SQLServerException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.fine(logger.toString() + " MSAL exception:" + e.getMessage());
            }
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_MSALExecution"));
            Object[] msgArgs = new Object[]{user, authenticationString};
            String correctedErrorMessage = e.getCause().getMessage().replaceAll("\\\\r\\\\n", "\r\n");
            RuntimeException correctedAuthenticationException = new RuntimeException(correctedErrorMessage);
            ExecutionException correctedExecutionException = new ExecutionException(correctedAuthenticationException);
            throw new SQLServerException(form.format(msgArgs), null, 0, (Throwable)correctedExecutionException);
        }
        finally {
            executorService.shutdown();
        }
    }

    static SqlFedAuthToken getSqlFedAuthTokenIntegrated(SQLServerConnection.SqlFedAuthInfo fedAuthInfo, String authenticationString) throws SQLServerException {
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        try {
            KerberosPrincipal kerberosPrincipal = new KerberosPrincipal("username");
            String user = kerberosPrincipal.getName();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(logger.toString() + " realm name is:" + kerberosPrincipal.getRealm());
            }
            PublicClientApplication clientApplication = ((PublicClientApplication.Builder)((PublicClientApplication.Builder)PublicClientApplication.builder((String)"7f98cb04-cd1e-40df-9140-3bf7e2cea4db").executorService(executorService)).authority(fedAuthInfo.stsurl)).build();
            CompletableFuture future = clientApplication.acquireToken(IntegratedWindowsAuthenticationParameters.builder(Collections.singleton(fedAuthInfo.spn + "/.default"), (String)user).build());
            IAuthenticationResult authenticationResult = (IAuthenticationResult)future.get();
            SqlFedAuthToken sqlFedAuthToken = new SqlFedAuthToken(authenticationResult.accessToken(), authenticationResult.expiresOnDate());
            return sqlFedAuthToken;
        }
        catch (IOException | InterruptedException e) {
            throw new SQLServerException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.fine(logger.toString() + " MSAL exception:" + e.getMessage());
            }
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_MSALExecution"));
            Object[] msgArgs = new Object[]{"", authenticationString};
            if (null == e.getCause() || null == e.getCause().getMessage()) {
                throw new SQLServerException(form.format(msgArgs), null);
            }
            String correctedErrorMessage = e.getCause().getMessage().replaceAll("\\\\r\\\\n", "\r\n");
            RuntimeException correctedAuthenticationException = new RuntimeException(correctedErrorMessage);
            ExecutionException correctedExecutionException = new ExecutionException(correctedAuthenticationException);
            throw new SQLServerException(form.format(msgArgs), null, 0, (Throwable)correctedExecutionException);
        }
        finally {
            executorService.shutdown();
        }
    }
}

