package com.microsoft.sqlserver.jdbc;
import java.util.*;
public final class SQLServerResource_zh_CN extends ListResourceBundle
				  {
protected Object[][]  getContents()
{
return contents;
}


static final Object[][] contents =
{
{"R_timedOutBeforeRouting","连接到路由目标之前已超时。"},
{"R_invalidRoutingInfo","接收到意外的路由信息。请检查连接属性和 SQL Server 配置。"},
{"R_multipleRedirections","发生了两个或更多重定向。每次登录尝试只允许有一次重定向。"},
{"R_dbMirroringWithMultiSubnetFailover","不支持使用 multiSubnetFailover 连接属性连接到镜像 SQL Server 实例。"},
{"R_dbMirroringWithReadOnlyIntent","不支持使用 ApplicationIntent ReadOnly 连接属性连接到镜像 SQL Server 实例。"},
{"R_ipAddressLimitWithMultiSubnetFailover","不支持使用 multiSubnetFailover 连接属性连接到配置了 {0} 个以上 IP 地址的 SQL Server 实例。"},
{"R_connectionTimedOut","连接超时: 无其他信息。"},
{"R_invalidPositionIndex","位置索引 {0} 无效。"},
{"R_invalidLength","长度 {0} 无效。"},
{"R_unknownSSType","SQL Server 数据类型 {0} 无效。"},
{"R_unknownJDBCType","JDBC 数据类型 {0} 无效。"},
{"R_notSQLServer","驱动程序收到意外的登录前响应。请验证连接属性，并检查 SQL Server 的实例正在主机上运行，且在此端口接受 TCP/IP 连接。该驱动程序只能与 SQL Server 2005 或更高版本一起使用。"},
{"R_tcpOpenFailed","{0}。请验证连接属性。确保 SQL Server 的实例正在主机上运行，且在此端口接受 TCP/IP 连接，还要确保防火墙没有阻止到此端口的 TCP 连接。"},
{"R_unsupportedServerVersion","该驱动程序不支持 SQL Server {0} 版。"},
{"R_noServerResponse","SQL Server 未返回响应。连接已关闭。"},
{"R_truncatedServerResponse","SQL Server 返回的响应不完整。连接已关闭。"},
{"R_queryTimedOut","查询超时。"},
{"R_queryCancelled","查询被取消。"},
{"R_errorReadingStream","从流对象读取值时发生了错误。错误:“{0}”"},
{"R_streamReadReturnedInvalidValue","对于所读取的数据量，流读取操作返回无效值。"},
{"R_mismatchedStreamLength","流值不是指定的长度。指定长度为 {0}，实际长度为 {1}。"},
{"R_notSupported","不支持此操作。"},
{"R_invalidOutputParameter","输出参数的索引 {0} 无效。"},
{"R_outputParameterNotRegisteredForOutput","没有为输出注册输出参数 {0}。"},
{"R_parameterNotDefinedForProcedure","没有为存储过程 {1} 定义参数 {0}。"},
{"R_connectionIsClosed","该连接已关闭。"},
{"R_invalidBooleanValue","属性 {0} 未包含有效布尔值。仅可使用 true 或 false。"},
{"R_propertyMaximumExceedsChars","{0} 属性的字符数超出最大值 {1}。"},
{"R_invalidPortNumber","端口号 {0} 无效。"},
{"R_invalidTimeOut","timeout {0} 无效。"},
{"R_invalidLockTimeOut","lockTimeOut {0} 无效。"},
{"R_invalidAuthenticationScheme","authenticationScheme {0} 无效。"},
{"R_invalidPacketSize","packetSize {0} 无效。"},
{"R_packetSizeTooBigForSSL","SSL 加密不能用于大小超过 {0} 字节的网络数据包。请检查您的连接属性和 SQL Server 配置。"},
{"R_redirectedFrom","{0} (从 {1} 重定向)"},
{"R_tcpipConnectionFailed","通过端口 {1} 连接到主机 {0} 的 TCP/IP 连接失败。错误:“{2}”。"},
{"R_invalidTransactionLevel","事务级别 {0} 无效。"},
{"R_cantInvokeRollback","AutoCommit 模式设置为“true”时，无法调用回滚操作。"},
{"R_cantSetSavepoint","AutoCommit 模式设置为“true”时，无法设置保存点。"},
{"R_sqlServerHoldability","SQL Server 仅支持连接级别的保持能力。请使用 connection.setHoldability() 方法。"},
{"R_invalidHoldability","保持能力值 {0} 无效。"},
{"R_invalidColumnArrayLength","列阵列无效。其长度必须为 1。"},
{"R_valueNotSetForParameter","没有为参数号 {0} 设置值。"},
{"R_sqlBrowserFailed","无法连接到命名实例 {1} 上的主机 {0}。错误:“{2}”。请验证服务器和实例名称是否正确无误，并检查是否没有防火墙在阻止流向端口 1434 的 UDP 流量。对于 SQL Server 2005 或更高版本，请验证 SQL Server Browser 服务是否正在主机上运行。"},
{"R_notConfiguredToListentcpip","服务器 {0} 没有配置为使用 TCP/IP 监听。"},
{"R_cantIdentifyTableMetadata","无法识别元数据的表 {0}。"},
{"R_metaDataErrorForParameter","参数 {0} 发生了元数据错误。"},
{"R_invalidParameterNumber","参数号 {0} 无效。"},
{"R_noMetadata","没有元数据。"},
{"R_resultsetClosed","结果集已关闭。"},
{"R_invalidColumnName","列名 {0} 无效。"},
{"R_resultsetNotUpdatable","结果集不可更新。"},
{"R_indexOutOfRange","索引 {0} 超出范围。"},
{"R_savepointNotNamed","savepoint 未命名。"},
{"R_savepointNamed","savepoint {0} 已命名。"},
{"R_resultsetNoCurrentRow","结果集没有当前行。"},
{"R_mustBeOnInsertRow","游标没有位于插入行。"},
{"R_mustNotBeOnInsertRow","请求的操作对插入行无效。"},
{"R_cantUpdateDeletedRow","无法更新已删除的行。"},
{"R_noResultset","该语句没有返回结果集。"},
{"R_resultsetGeneratedForUpdate","已生成用于更新的结果集。"},
{"R_statementIsClosed","该语句已关闭。"},
{"R_invalidRowcount","结果集的最大行数 {0} 必须为非负数。"},
{"R_invalidQueryTimeOutValue","查询超时值 {0} 无效。"},
{"R_invalidFetchDirection","提取方向 {0} 无效。"},
{"R_invalidFetchSize","提取大小不能为负。"},
{"R_noColumnParameterValue","没有指定用于更新行的列参数值。"},
{"R_statementMustBeExecuted","必须执行该语句才能获得结果。"},
{"R_modeSuppliedNotValid","提供的模式无效。"},
{"R_errorConnectionString","连接字符串包含的名称或值的格式错误。"},
{"R_errorProcessingComplexQuery","处理复杂查询期间发生错误。"},
{"R_invalidOffset","偏移量 {0} 无效。"},
{"R_nullConnection","连接 URL 为 null。"},
{"R_invalidConnection","连接 URL 无效。"},
{"R_cannotTakeArgumentsPreparedOrCallable","对于 PreparedStatement 或 CallableStatement，方法 {0} 不能带有参数。"},
{"R_unsupportedConversionFromTo","不支持从 {0} 到 {1} 的转换。"},
{"R_unsupportedConversionTo","不支持转换到 {0}。"},
{"R_errorConvertingValue","将 {0} 值转换为 JDBC 数据类型 {1} 时发生错误。"},
{"R_streamIsClosed","该流已关闭。"},
{"R_invalidTDS","TDS 协议流无效。"},
{"R_unexpectedToken"," 意外的 token {0}。"},
{"R_selectNotPermittedinBatch","批处理中不允许使用 SELECT 语句。"},
{"R_failedToCreateXAConnection","无法创建 XA 控制连接。错误:“{0}”。"},
{"R_codePageNotSupported","Java 环境不支持代码页 {0}。"},
{"R_unknownSortId","此驱动程序不支持 SQL Server 排序规则 {0}。"},
{"R_unknownLCID","此驱动程序不支持 Windows 排序规则 {0}。"},
{"R_encodingErrorWritingTDS","将字符串写入 TDS 缓冲区时发生编码错误。错误:“{0}”。"},
{"R_processingError","发生了处理错误“{0}”。"},
{"R_requestedOpNotSupportedOnForward","只进结果集不支持请求的操作。"},
{"R_unsupportedCursor","不支持此游标类型。"},
{"R_unsupportedCursorOperation","此游标类型不支持请求的操作。"},
{"R_unsupportedConcurrency","不支持并发。"},
{"R_unsupportedCursorAndConcurrency","不支持此游标类型/并发组合。"},
{"R_stringReadError","偏移量 {0} 处发生字符串读取错误。"},
{"R_stringWriteError","偏移量 {0} 处发生字符串写入错误。"},
{"R_stringNotInHex","该字符串未使用有效的十六进制格式。"},
{"R_unknownType","不支持 Java 类型 {0}。"},
{"R_physicalConnectionIsClosed","该池连接的物理连接已关闭。"},
{"R_invalidDataSourceReference","无效的 DataSource 引用。"},
{"R_cantGetColumnValueFromDeletedRow","无法从已删除行获取值。"},
{"R_cantGetUpdatedColumnValue","在调用 updateRow() 或 cancelRowUpdates() 之前，无法访问已更新列。"},
{"R_cantUpdateColumn","列值无法更新。"},
{"R_positionedUpdatesNotSupported","不支持定位的更新和删除。"},
{"R_invalidAutoGeneratedKeys","autoGeneratedKeys 参数值 {0} 无效。只能使用值 Statement.RETURN_GENERATED_KEYS 和 Statement.NO_GENERATED_KEYS。"},
{"R_notConfiguredForIntegrated","没有为集成身份验证配置驱动程序。"},
{"R_failoverPartnerWithoutDB","使用 failoverPartner 连接属性时需要有 databaseName。"},
{"R_invalidPartnerConfiguration","服务器 {1} 上的数据库 {0} 未配置为数据库镜像。"},
{"R_invaliddisableStatementPooling","disableStatementPooling 值 {0} 无效。"},
{"R_invalidselectMethod","selectMethod {0} 无效。"},
{"R_invalidpropertyValue","连接属性 {0} 的数据类型无效。用于此连接的所有属性必须为“String”类型。"},
{"R_invalidArgument","参数 {0} 无效。"},
{"R_streamWasNotMarkedBefore","尚未标记该流。"},
{"R_invalidresponseBuffering","responseBuffering 连接属性 {0} 无效。"},
{"R_invalidapplicationIntent","applicationIntent 连接属性 {0} 无效。"},
{"R_dataAlreadyAccessed","数据已存取，不可用于此列或参数。"},
{"R_outParamsNotPermittedinBatch","批处理中不允许使用 OUT 和 INOUT 参数。"},
{"R_sslRequiredNoServerSupport","驱动程序无法使用安全套接字层(SSL)加密与 SQL Server 建立安全连接。应用程序要求加密，但服务器未配置为支持 SSL。"},
{"R_sslRequiredByServer","SQL Server 登录要求使用安全套接字层(SSL)进行加密连接。"},
{"R_sslFailed","驱动程序无法通过使用安全套接字层(SSL)加密与 SQL Server 建立安全连接。错误:“{0}”。"},
{"R_certNameFailed","在安全套接字层(SSL)初始化过程中验证证书中的服务器名称失败。"},
{"R_failedToInitializeXA","初始化储存过程 xp_sqljdbc_xa_init 失败。状态为: {0}。错误:“{1}”"},
{"R_failedFunctionXA","函数 {0} 失败。状态为: {1}。错误:“{2}”"},
{"R_noTransactionCookie","函数 {0} 失败。未返回任何事务 cookie。"},
{"R_failedToEnlist","登记失败。错误:“{0}”"},
{"R_failedToUnEnlist","取消登记失败。错误:“{0}”"},
{"R_failedToReadRecoveryXIDs","读取恢复 XA 分支事务 ID (XID)失败。错误:“{0}”"},
{"R_userPropertyDescription","数据库用户。"},
{"R_passwordPropertyDescription","数据库密码。"},
{"R_databaseNamePropertyDescription","要连接的数据库名称。"},
{"R_domainPropertyDescription","用于在使用 NTLM 时进行身份验证的 Windows 域。"},
{"R_serverNamePropertyDescription","运行 SQL Server 的计算机。"},
{"R_portNumberPropertyDescription","SQL Server 实例正在侦听的 TCP 端口。"},
{"R_serverSpnPropertyDescription","SQL Server SPN。"},
{"R_columnEncryptionSettingPropertyDescription","列加密设置。"},
{"R_enclaveAttestationUrlPropertyDescription","enclave 证明 URL。"},
{"R_enclaveAttestationProtocolPropertyDescription","enclave 证明协议。"},
{"R_serverNameAsACEPropertyDescription","将 serverName 从 Unicode 转换为 ASCII Compatible Encoding (ACE)，如 RFC 3490 的 ToASCII 操作所定义。"},
{"R_sendStringParametersAsUnicodePropertyDescription","确定字符串参数是否以 Unicode 或数据库字符集的形式发送至服务器。"},
{"R_multiSubnetFailoverPropertyDescription","表明该应用程序正在连接到可用性组的可用性组侦听器或故障转移群集实例。"},
{"R_applicationNamePropertyDescription","SQL Server 事件探查和日志记录工具的应用程序名称。"},
{"R_lastUpdateCountPropertyDescription","确保仅从传递给服务器的 SQL 语句中返回上次更新计数。"},
{"R_disableStatementPoolingPropertyDescription","禁用语句池功能。"},
{"R_integratedSecurityPropertyDescription","指示是否将使用 Windows 身份验证来连接至 SQL Server。"},
{"R_authenticationSchemePropertyDescription","要用于集成身份验证的验证架构。"},
{"R_lockTimeoutPropertyDescription","在数据库报告锁定超时前需要等待的毫秒数。"},
{"R_loginTimeoutPropertyDescription","在失败的连接超时之前，驱动程序需要等待的秒数。"},
{"R_instanceNamePropertyDescription","要连接的 SQL Server 实例的名称。"},
{"R_xopenStatesPropertyDescription","确定驱动程序是否在异常中返回符合 XOPEN 的 SQL 状态代码。"},
{"R_selectMethodPropertyDescription","允许应用程序使用服务器游标来处理只进、只读结果集。"},
{"R_responseBufferingPropertyDescription","控制自适应缓冲行为，从而使应用程序无需服务器游标即可处理大型结果集。"},
{"R_applicationIntentPropertyDescription","连接到服务器时声明应用程序负载类型。可能的值为 ReadOnly 和 ReadWrite。"},
{"R_workstationIDPropertyDescription","工作站的主机名。"},
{"R_failoverPartnerPropertyDescription","数据库镜像配置中使用的故障转移服务器的名称。"},
{"R_packetSizePropertyDescription","用来与 SQL Server 通信的网络数据包大小。"},
{"R_encryptPropertyDescription","确定在客户端和服务器间是否使用安全套接字层(SSL)加密。"},
{"R_socketFactoryClassPropertyDescription","要实例化为连接的 SocketFactory 的类"},
{"R_socketFactoryConstructorArgPropertyDescription","要传递给由 socketFactoryClass 指定的构造函数的可选参数"},
{"R_trustServerCertificatePropertyDescription","确定驱动程序是否应对 SQL Server 安全套接字层(SSL)证书进行验证。"},
{"R_trustStoreTypePropertyDescription","KeyStore 类型。"},
{"R_trustStorePropertyDescription","证书 TrustStore 文件的路径。"},
{"R_trustStorePasswordPropertyDescription","用于检查信任存储区数据完整性的密码。"},
{"R_trustManagerClassPropertyDescription","要实例化为 SSL 连接的 TrustManager 的类。"},
{"R_trustManagerConstructorArgPropertyDescription","要传递给 trustManagerClass 指定的构造函数的可选参数。"},
{"R_hostNameInCertificatePropertyDescription","验证 SQL Server 安全套接字层(SSL)证书时要使用的主机名。"},
{"R_sendTimeAsDatetimePropertyDescription","确定是否使用 SQL Server datetime 数据类型将 java.sql.Time 值发送到数据库。"},
{"R_TransparentNetworkIPResolutionPropertyDescription","确定是否使用透明网络 IP 解析功能。"},
{"R_queryTimeoutPropertyDescription","在数据库报告查询超时前需要等待的秒数。"},
{"R_socketTimeoutPropertyDescription","引发 java.net.SocketTimeoutException 前需要等待的毫秒数。"},
{"R_serverPreparedStatementDiscardThresholdPropertyDescription","何时在服务器上关闭弃用的 prepare 语句(调用一批 sp_unprepare)的阈值。值不超过 1 会导致在关闭 PreparedStatment 后立即调用 sp_unprepare。"},
{"R_enablePrepareOnFirstPreparedStatementCallPropertyDescription","此设置指定是在首次使用时(property=true)还是在首次调用 sp_executesql 后第二次使用时(property=false)预定义语句(sp_prepexec)。"},
{"R_statementPoolingCacheSizePropertyDescription","此设置指定连接的已准备语句缓存的大小。小于 1 的值表示没有缓存。"},
{"R_gsscredentialPropertyDescription","用于访问 SQL Server 的模拟 GSS 凭据。"},
{"R_msiClientIdPropertyDescription","用于生成 Azure AD MSI 身份验证的访问令牌的用户分配的托管标识的客户端 ID"},
{"R_clientCertificatePropertyDescription","客户端证书身份验证功能的客户端证书路径。"},
{"R_clientKeyPropertyDescription","客户端证书身份验证功能的私钥文件路径。"},
{"R_clientKeyPasswordPropertyDescription","私钥的密码(如果私钥受密码保护)。"},
{"R_sendTemporalDataTypesAsStringForBulkCopyPropertyDescription","指明驱动程序是否将临时数据类型作为字符串值发送到服务器以供大容量复制的标志。"},
{"R_delayLoadingLobsPropertyDescription","指明驱动程序是否将 LOB 数据类型加载到内存中的布尔型标志。"},
{"R_AADSecurePrincipalIdPropertyDescription","已被授予对已连接数据库的权限的已注册应用程序的应用程序 ID。"},
{"R_AADSecurePrincipalSecretPropertyDescription","为已注册应用程序定义的机密，应用程序已被授予对已连接数据库的权限。"},
{"R_noParserSupport","实例化所需的分析器时发生错误。错误:“{0}”"},
{"R_writeOnlyXML","无法从此 SQLXML 实例中进行读取。此实例只用于写入数据。"},
{"R_dataHasBeenReadXML","无法从此 SQLXML 实例中进行读取。数据已被读取。"},
{"R_readOnlyXML","无法写入此 SQLXML 实例。此实例只用于读取数据。"},
{"R_dataHasBeenSetXML","无法写入此 SQLXML 实例。数据已被设置。"},
{"R_noDataXML","此 SQLXML 实例中没有设置数据。"},
{"R_cantSetNull","无法设置 null 值。"},
{"R_failedToParseXML","分析 XML 失败。错误:“{0}”"},
{"R_isFreed","对象 {0} 已被释放，无法再对其进行访问。"},
{"R_invalidProperty","不支持此属性: {0}。"},
{"R_referencingFailedTSP","需要设置 DataSource trustStore 密码。"},
{"R_valueOutOfRange","一个或多个值超出了 {0} SQL Server 数据类型的值范围。"},
{"R_valueOutOfRangeSQLType","一个或多个值超出了 {0} SQL 类型的范围。"},
{"R_integratedAuthenticationFailed","集成身份验证失败。"},
{"R_permissionDenied","安全冲突。目标“{0}”的权限已拒绝。"},
{"R_getSchemaError","获取默认架构名称时出错。"},
{"R_setSchemaWarning","警告: 在此驱动程序版本中，setSchema 无操作。"},
{"R_updateCountOutofRange","更新计数值超出范围。"},
{"R_limitOffsetNotSupported","不支持在限制转义序列中使用 OFFSET 子句。"},
{"R_limitEscapeSyntaxError","限制转义语法出错。分析查询失败。"},
{"R_featureNotSupported","{0} 不受支持。"},
{"R_zoneOffsetError","检索区域偏移量时出错。"},
{"R_invalidMaxRows","对结果集所支持的最大行数小于或等于 Integer.MAX_VALUE。"},
{"R_schemaMismatch","源和目标架构不匹配。"},
{"R_invalidColumn","{0} 列无效。请检查列映射。"},
{"R_invalidDestinationTable","目标表名缺失或无效。"},
{"R_unableRetrieveColMeta","无法检索列元数据。"},
{"R_invalidDestConnection","目标连接必须是来自 Microsoft JDBC Driver for SQL Server 的连接。"},
{"R_unableRetrieveSourceData","无法检索源数据。"},
{"R_ParsingError","无法针对 {0} 类型分析数据。"},
{"R_ParsingDataError","无法为 {1} 类型分析数据 {0}。"},
{"R_BulkTypeNotSupported","大容量复制不支持数据类型 {0}。"},
{"R_BulkTypeNotSupportedDW","在针对 Azure 数据仓库的大容量复制中不支持数据类型 {0}。"},
{"R_invalidTransactionOption","使用 Connection 对象时，不能将 UseInternalTransaction 选项设置为 TRUE。"},
{"R_invalidNegativeArg","{0} 参数不能为负数。"},
{"R_BulkColumnMappingsIsEmpty","如果只有映射是标识列，且 KeepIdentity 已设置为 false，则无法执行大容量复制操作。"},
{"R_DataSchemaMismatch","源数据与源架构不匹配。"},
{"R_BulkDataDuplicateColumn","不允许重复的列名。"},
{"R_invalidColumnOrdinal","列 {0} 无效。列号应大于零。"},
{"R_unsupportedEncoding","编码 {0} 不受支持。"},
{"R_UnexpectedDescribeParamFormat","内部错误。sp_describe_parameter_encryption 返回的结果集的格式无效。其中一个结果集缺失。"},
{"R_InvalidEncryptionKeyOrdinal","内部错误。sp_describe_parameter_encryption 返回的加密元数据中缺少引用的列加密密钥序号“{0}”。最大序号是“{1}”。"},
{"R_MissingParamEncryptionMetadata","内部错误。sp_describe_parameter_encryption 返回的结果集中缺少语句或过程“{0}”中一些参数的元数据。"},
{"R_UnableRetrieveParameterMetadata","无法检索参数加密元数据。"},
{"R_InvalidCipherTextSize","指定的已加密文本的大小(即 {0} 字节)无效，低于解密所需的大小下限(即 {1} 字节)。"},
{"R_InvalidAlgorithmVersion","指定的已加密文本的加密算法版本 {0} 与预期的加密算法版本 {1} 不一致。"},
{"R_InvalidAuthenticationTag","指定的已加密文本包含无效的身份验证标记。"},
{"R_EncryptionFailed","加密时出现内部错误: {0}"},
{"R_DecryptionFailed","解密时出现内部错误: {0}"},
{"R_InvalidKeySize","列加密密钥已成功解密，但它的长度 {0} 与算法“{2}”对应的长度 {1} 不一致。请验证数据库中列加密密钥的已加密值。"},
{"R_InvalidEncryptionType","为数据库中的列指定的加密类型 {0} 无效或已损坏。算法 {1} 对应的有效加密类型为: {2}。"},
{"R_UnknownColumnEncryptionAlgorithm","没有算法 {0}。在工厂中注册的算法是 {1}。"},
{"R_KeyExtractionFailed","密钥提取失败: {0}。"},
{"R_UntrustedKeyPath","从服务器 {1} 收到的列主密钥路径 {0} 不是受信任的密钥路径。列主密钥路径可能已损坏，或者你应使用 SQLServerConnection.setColumnEncryptionTrustedMasterKeyPaths() 将 {0} 设为受信任的密钥路径。"},
{"R_UnrecognizedKeyStoreProviderName","无法解密列加密密钥。密钥存储提供程序名称无效: {0}。密钥存储提供程序名称必须指明系统密钥存储提供程序或已注册的自定义密钥存储提供程序。有效的系统密钥提供程序名称为: {1}。有效的(当前已注册)自定义密钥存储提供程序名称为: {2}。请验证数据库中列主密钥定义中的密钥存储提供程序信息，并验证你应用程序中使用的所有自定义密钥存储提供程序是否都已正确注册。"},
{"R_UnsupportedDataTypeAE","不支持对数据类型 {0} 进行加密和解密。"},
{"R_NormalizationErrorAE","无法对数据类型 {0} 解密。规范化错误。"},
{"R_UnsupportedNormalizationVersionAE","从 SQL Server 收到的规范化版本“{0}”无效或已损坏。有效的规范化版本为: {1}。"},
{"R_NullCipherTextAE","内部错误。Ciphertext 值不能为 NULL。"},
{"R_NullColumnEncryptionAlgorithmAE","内部错误。加密算法不能为 NULL。有效的算法为: {1}。"},
{"R_CustomCipherAlgorithmNotSupportedAE","自定义密码算法不受支持。"},
{"R_PlainTextNullAE","内部错误。Plaintext 值不能为 NULL。"},
{"R_StreamingDataTypeAE","已加密 {1} 列不支持长度大于 {0} 的数据。"},
{"R_AE_NotSupportedByServer","使用中的 SQL Server 实例不支持列加密。"},
{"R_InvalidAEVersionNumber","对于“Always Encrypted”，收到了无效的版本号“{0}”。"},
{"R_NullEncryptedColumnEncryptionKey","内部错误。已加密列加密密钥不能为 NULL。"},
{"R_EmptyEncryptedColumnEncryptionKey","内部错误。指定的已加密列加密密钥是空的。"},
{"R_InvalidMasterKeyDetails","指定的主密钥详细信息无效。"},
{"R_CertificateError","从密钥存储“{1}”检索证书“{0}”时出错了。"},
{"R_ByteToShortConversion","解密列加密密钥时出错了。"},
{"R_InvalidCertificateSignature","指定的已加密列加密密钥签名与使用“{0}”中的列主密钥(证书)计算得出的签名不一致。已加密列加密密钥可能已损坏，或者指定的路径可能有误。"},
{"R_CEKDecryptionFailed","解密已加密列加密密钥时出现异常: {0}"},
{"R_NullKeyEncryptionAlgorithm","密钥加密算法不能为 NULL。"},
{"R_NullKeyEncryptionAlgorithmInternal","内部错误。密钥加密算法不能为 NULL。"},
{"R_InvalidKeyEncryptionAlgorithm","指定的密钥加密算法无效: {0}。值应为: {1}。"},
{"R_InvalidKeyEncryptionAlgorithmInternal","内部错误。指定的密钥加密算法无效: {0}。值应为: {1}。"},
{"R_NullColumnEncryptionKey","列加密密钥不能为 NULL。"},
{"R_EmptyColumnEncryptionKey","指定的列加密密钥是空的。"},
{"R_CertificateNotFoundForAlias","在 {1} 提供的存储中找不到别名为 {0} 的证书。请验证此证书是否已正确导入证书位置/存储。"},
{"R_UnrecoverableKeyAE","无法从包含证书详细信息 {0} 的密钥存储中恢复私钥。请验证导入的 Always Encrypted 证书是否包含私钥，且为证书提供的密码是否正确无误。"},
{"R_KeyStoreNotFound","系统在指定路径找不到密钥存储文件。请验证路径是否正确，且你是否有权访问它。"},
{"R_CustomKeyStoreProviderMapNull","列加密密钥存储提供程序映射不能为 NULL。应为非 NULL 值。"},
{"R_EmptyCustomKeyStoreProviderName","指定的密钥存储提供程序名称无效。密钥存储提供程序名称不能为 NULL 或空。"},
{"R_InvalidCustomKeyStoreProviderName","密钥存储提供程序名称 {0} 无效。{1} 前缀是专为系统密钥存储提供程序而保留。"},
{"R_CustomKeyStoreProviderValueNull","为密钥存储提供程序 {0} 指定的引用为 NULL。应为非 NULL 值。"},
{"R_CustomKeyStoreProviderSetOnce","不能多次设置密钥存储提供程序。"},
{"R_unknownColumnEncryptionType","列加密类型 {0} 无效。"},
{"R_unsupportedStmtColEncSetting","SQLServerStatementColumnEncryptionSetting 不能为 NULL。"},
{"R_unsupportedConversionAE","对于已加密列，不支持从 {0} 转换为 {1}。"},
{"R_InvalidDataForAE","数据源中类型 {0} 的给定值无法转换为指定目标列的类型 {1}。"},
{"R_authenticationPropertyDescription","要使用的身份验证。"},
{"R_accessTokenPropertyDescription","要对 Azure Active Directory 使用的访问令牌。"},
{"R_FedAuthRequiredPreLoginResponseInvalidValue","服务器发送了 FedAuthRequired PreLogin 选项的非预期值。值为 {0}。"},
{"R_FedAuthInfoLengthTooShortForCountOfInfoIds","FedAuthInfo 标记至少必须包含 4 字节，用于指明信息 ID 的数量。"},
{"R_FedAuthInfoInvalidOffset","FedAuthInfoDataOffset 指向的位置无效。当前的 dataOffset 是 {0}。"},
{"R_FedAuthInfoFailedToReadData","无法读取 FedAuthInfoData。"},
{"R_FedAuthInfoLengthTooShortForData","FEDAUTHINFO 标记流不够长({0})，无法包含它所声明的数据。"},
{"R_FedAuthInfoDoesNotContainStsurlAndSpn","FEDAUTHINFO 标记流中没有 STSURL 和 SPN。"},
{"R_MSALExecution","无法在 Active Directory 中对用户 {0} 进行身份验证(Authentication={1})。"},
{"R_MSALAuthComplete","身份验证完成。你可以关闭浏览器并返回到应用程序。"},
{"R_UnrequestedFeatureAckReceived","收到了未请求的功能确认。功能 ID: {0}。"},
{"R_FedAuthFeatureAckContainsExtraData","ADAL 和 Security Token 的联合身份验证功能扩展确认包含额外数据。"},
{"R_FedAuthFeatureAckUnknownLibraryType","正在尝试使用未知的联合身份验证 库。库 ID: {0}。"},
{"R_UnknownFeatureAck","收到了未知的功能确认。"},
{"R_SetAuthenticationWhenIntegratedSecurityTrue","在 \"IntegratedSecurity\" 已设为 \"true\" 的情况下，无法设置 \"Authentication\"。"},
{"R_NtlmNoUserPasswordDomain","必须为 NTLM 身份验证指定 \"User\" (或 \"UserName\") 和 \"Password\" 连接属性。"},
{"R_SetAccesstokenWhenIntegratedSecurityTrue","如果 \"IntegratedSecurity\" 连接字符串关键字已设为 \"true\"，则无法设置 AccessToken 属性。"},
{"R_IntegratedAuthenticationWithUserPassword","无法将 \"Authentication=ActiveDirectoryIntegrated\" 与 \"User\"、\"UserName\" 或 \"Password\" 连接字符串关键字结合使用。"},
{"R_MSIAuthenticationWithUserPassword","无法将 \"Authentication=ActiveDirectoryMSI\" 与 \"User\"、\"UserName\" 或 \"Password\" 连接字符串关键字结合使用。"},
{"R_AccessTokenWithUserPassword","如果连接字符串中指定了 \"User\"、\"UserName\" 或 \"Password\"，则无法设置 AccessToken 属性。"},
{"R_AccessTokenCannotBeEmpty","AccesToken 不能为空。"},
{"R_SetBothAuthenticationAndAccessToken","如果连接字符串中指定了 \"Authentication\"，则无法设置 AccessToken 属性。"},
{"R_NoUserPasswordForActivePassword","如果 \"Authentication=ActiveDirectoryPassword\"，则必须同时指定 \"User\" (或 \"UserName\")和 \"Password\" 连接字符串关键字。"},
{"R_NoUserPasswordForActiveServicePrincipal","如果 \"Authentication=ActiveDirectoryServicePrincipal\"，则必须同时指定 \"AADSecurePrincipalId\" 和 \"AADSecurePrincipalSecret\" 连接字符串关键字。"},
{"R_NoUserPasswordForSqlPassword","如果 \"Authentication=SqlPassword\"，则必须同时指定 \"User\" (或 \"UserName\")和 \"Password\" 连接字符串关键字。"},
{"R_ForceEncryptionTrue_HonorAEFalse","无法为参数 {0} 将“强制加密”设为 true，因为语句或过程 {1} 未启用加密。"},
{"R_ForceEncryptionTrue_HonorAETrue_UnencryptedColumn","无法执行语句或过程 {0}，因为你已为参数 {1} 将“强制加密”设为 true，而数据库要求将此参数作为纯文本发送。这可能是由于配置错误所致。"},
{"R_ForceEncryptionTrue_HonorAEFalseRS","无法为参数 {0} 将“强制加密”设为 true，因为语句或过程未启用加密。"},
{"R_ForceEncryptionTrue_HonorAETrue_UnencryptedColumnRS","无法执行更新，因为你已为参数 {0} 将“强制加密”设为 true，而数据库要求将此参数作为纯文本发送。这可能是由于配置错误所致。"},
{"R_NullValue","{0} 不能为 NULL。"},
{"R_AKVPathNull","Azure Key Vault 密钥路径不能为 NULL。"},
{"R_AKVURLInvalid","指定的 URL 无效: {0}。"},
{"R_AKVMasterKeyPathInvalid","指定的 Azure Key Vault 密钥路径无效: {0}。"},
{"R_ManagedIdentityInitFail","无法初始化包来获取 Azure Key Vault 的托管标识令牌。"},
{"R_EmptyCEK","指定的列加密密钥是空的。"},
{"R_EncryptedCEKNull","已加密列加密密钥不能为 NULL。"},
{"R_EmptyEncryptedCEK","已加密列加密密钥的长度不得为零。"},
{"R_NonRSAKey","无法使用非 RSA 密钥: {0}。"},
{"R_GetAKVKeySize","无法获取 Azure Key Vault 公钥大小(以字节为单位)。"},
{"R_InvalidEcryptionAlgorithmVersion","指定的已加密列加密密钥包含的加密算法版本 {0} 无效。版本应为 {1}。"},
{"R_AKVKeyLengthError","指定的已加密列加密密钥的 ciphertext 长度({0})与使用 {2} 中的列主密钥(Azure Key Vault 密钥)时的 ciphertext 长度({1})不一致。可能是因为已加密列加密密钥已损坏，或指定的 Azure Key Vault 密钥路径有误。"},
{"R_AKVSignatureLengthError","指定的已加密列加密密钥的签名长度({0})与使用 {2} 中的列主密钥(Azure Key Vault 密钥)时的签名长度({1})不一致。可能是因为已加密列加密密钥已损坏，或指定的 Azure Key Vault 密钥路径有误。"},
{"R_HashNull","在解密已加密列加密密钥时，哈希不得为 NULL。"},
{"R_NoSHA256Algorithm","SHA-256 算法不受支持。"},
{"R_VerifySignature","无法验证列加密密钥的签名。"},
{"R_CEKSignatureNotMatchCMK","指定的已加密列加密密钥签名与使用 {0} 中的列主密钥(Azure Key Vault 中的非对称密钥)计算得出的签名不一致。已加密列加密密钥可能已损坏，或者指定的路径可能有误。"},
{"R_DecryptCEKError","无法使用指定的 Azure Key Vault 密钥解密列加密密钥。"},
{"R_EncryptCEKError","无法使用指定的 Azure Key Vault 密钥加密列加密密钥。"},
{"R_CipherTextLengthNotMatchRSASize","CipherText 长度与 RSA 密钥大小不匹配。"},
{"R_GenerateSignature","无法使用指定的 Azure Key Vault 密钥 URL 生成签名。"},
{"R_SignedHashLengthError","已签名的哈希长度与 RSA 密钥大小不匹配。"},
{"R_InvalidSignatureComputed","所计算的已加密列加密密钥签名无效。"},
{"R_UnableLoadADALSqlDll","无法加载 adalsql.dll。错误代码: 0x{0}。有关详细信息，请访问: http://go.microsoft.com/fwlink/?LinkID=513072"},
{"R_ADALAuthenticationMiddleErrorMessage","错误代码: 0x{0}; 状态: {1}。"},
{"R_unsupportedDataTypeTVP","Table-Valued Parameter 不支持数据类型 {0}。"},
{"R_moreDataInRowThanColumnInTVP","输入阵列的长度超过了此表中的列数。"},
{"R_invalidTVPName","Table-Valued Parameter 必须具有有效的类型名称。"},
{"R_invalidThreePartName","TypeName 采用的 3 部分名称格式无效。"},
{"R_unsupportedConversionTVP","对于 Table-Valued Parameter，不支持从 {0} 转换为 {1}。"},
{"R_TVPMixedSource","无法添加列元数据。此 Table-Valued Parameter 具有元数据派生自的 ResultSet。"},
{"R_TVPEmptyMetadata","结构化类型中没有足够的字段。结构化类型至少必须有一个字段。"},
{"R_TVPInvalidValue","为 Table-Valued Parameter {0} 提供的值无效。只支持 SQLServerDataTable、ResultSet 和 ISQLServerDataRecord 对象。"},
{"R_TVPInvalidColumnValue","输入数据的格式有误。"},
{"R_TVPSortOrdinalGreaterThanFieldCount","字段 {1} 的排序序号 {0} 超出了字段总数。"},
{"R_TVPMissingSortOrderOrOrdinal","要么必须同时指定排序顺序和序号，要么两者都不应指定(SortOrder.Unspecified 和 -1)。给定的值为: 顺序 = {0}，序号 = {1}。"},
{"R_TVPDuplicateSortOrdinal","排序序号 {0} 指定了两次。"},
{"R_TVPMissingSortOrdinal","未指定排序序号 {0}。"},
{"R_TVPDuplicateColumnName","列名称 {0} 已属于此 SQLServerDataTable。"},
{"R_InvalidConnectionSetting","{0} 值“{1}”无效。"},
{"R_InvalidWindowsCertificateStoreEncryption","无法使用 Windows Certificate Store 加密列加密密钥。"},
{"R_AEKeypathEmpty","内部错误。证书路径不能为 NULL。请使用以下格式:“证书位置/证书存储/证书指纹”，其中“证书位置”是 LocalMachine 或 CurrentUser。"},
{"R_AEWinApiErr","Windows API 本机错误。"},
{"R_AECertpathBad","内部错误。证书路径无效: {0}。请使用以下格式:“证书位置/证书存储/证书指纹”，其中“证书位置”是 LocalMachine 或 CurrentUser。"},
{"R_AECertLocBad","内部错误。证书路径 {1} 中的证书位置 {0} 无效。请使用以下格式:“证书位置/证书存储/证书指纹”，其中“证书位置”是 LocalMachine 或 CurrentUser。"},
{"R_AECertStoreBad","内部错误。证书路径 {1} 中指定的证书存储 {0} 无效。值应为: My。"},
{"R_AECertHashEmpty","内部错误。证书路径 {0} 中指定的证书指纹是空的。"},
{"R_AECertNotFound","在证书位置 {0} 中，在证书存储 {1} 找不到包含指纹 {2} 的证书。请验证数据库中列主密钥定义内的证书路径是否正确，且证书是否已正确导入证书位置/存储。"},
{"R_AEMaloc","内存分配失败。"},
{"R_AEKeypathLong","内部错误。指定的证书路径大小为 {0} 字节，超过了长度上限(即 {1} 字节)。"},
{"R_AEECEKLenBad","指定的已加密列加密密钥的 ciphertext 长度({0})与使用“{2}”中的列主密钥(证书)时的 ciphertext 长度({1})不一致。可能是因为已加密列加密密钥已损坏，或指定的证书路径有误。"},
{"R_AEECEKSigLenBad","指定的已加密列加密密钥的签名长度({0})与使用“{2}”中的列主密钥(证书)时的长度({1})不一致。可能是因为已加密列加密密钥已损坏，或指定的证书路径有误。"},
{"R_AEKeyPathEmptyOrReserved","证书路径“{0}”无效，因为它是空的或包含保留的目录名称。"},
{"R_AEKeyPathCurUser","密钥路径中指定的是 CurrentUser，但在获取当前用户的初始工作目录时出错了。"},
{"R_AEKeyFileOpenError","打开证书文件 {0} 时出错了。"},
{"R_AEKeyFileReadError","读取证书文件 {0} 时出错了。"},
{"R_keyStoreAuthenticationPropertyDescription","用于标识密钥存储的名称。"},
{"R_keyStoreSecretPropertyDescription","定位密钥所需的身份验证密钥或信息。"},
{"R_keyStoreLocationPropertyDescription","密钥存储位置。"},
{"R_keyStoreAuthenticationNotSet","如果已指定“{0}”，则必须指定 \"keyStoreAuthentication\" 连接字符串关键字。"},
{"R_keyStoreSecretOrLocationNotSet","如果在连接字符串中指定了 \"keyStoreAuthentication=JavaKeyStorePassword\"，则必须同时设置 \"keyStoreSecret\" 和 \"keyStoreLocation\"。"},
{"R_keyStoreSecretNotSet","如果已在连接字符串中指定了 \"keyStoreAuthentication=KeyVaultClientSecret\"，则必须设置 \"keyStoreSecret\"。"},
{"R_certificateStoreInvalidKeyword","如果在连接字符串中指定了 \"keyStoreAuthentication=CertificateStore\"，则不能设置 \"keyStoreSecret\"。"},
{"R_certificateStoreLocationNotSet","如果在连接字符串中指定了 \"keyStoreAuthentication=CertificateStore\"，则必须设置 \"keyStoreLocation\"。"},
{"R_certificateStorePlatformInvalid","无法在 Windows 操作系统上设置 \"keyStoreAuthentication=CertificateStore\"。"},
{"R_invalidKeyStoreFile","无法分析“{0}”。文件格式无效或者密码不正确。"},
{"R_invalidCEKCacheTtl","指定的列加密密钥缓存生存时间无效。columnEncryptionKeyCacheTtl 值不能为负，且时间单位只能是 DAYS、HOURS、MINUTES 或 SECONDS。"},
{"R_sendTimeAsDateTimeForAE","在使用 Always Encrypted 时，使用 sendTimeAsDateTime=false。"},
{"R_TVPnotWorkWithSetObjectResultSet","表值参数不支持使用 ResultSet 的 setObject()。请使用 setStructured()。"},
{"R_invalidQueryTimeout","queryTimeout {0} 无效。"},
{"R_invalidSocketTimeout","socketTimeout {0} 无效。"},
{"R_fipsPropertyDescription","确定是否已启用 FIPS 模式。"},
{"R_invalidFipsConfig","无法验证 FIPS 模式设置。"},
{"R_serverPreparedStatementDiscardThreshold","serverPreparedStatementDiscardThreshold {0} 无效。"},
{"R_statementPoolingCacheSize","statementPoolingCacheSize {0} 无效。"},
{"R_kerberosLoginFailedForUsername","无法使用 Kerberos 主体 {0} 登录，请检查凭据。{1}"},
{"R_kerberosLoginFailed","Kerberos 登录失败: {0} 原因是 {1} ({2})"},
{"R_StoredProcedureNotFound","找不到存储过程“{0}”。"},
{"R_jaasConfigurationNamePropertyDescription","Kerberos 身份验证的登录配置文件。"},
{"R_AKVKeyNotFound","未找到密钥: {0}"},
{"R_SQLVariantSupport","2008 之前的 SQL Server 版本中不支持 SQL_VARIANT。"},
{"R_invalidProbbytes","SQL_VARIANT: {0} 类型的 probBytes 无效。"},
{"R_invalidStringValue","SQL_VARIANT 不支持长度大于 8000 的字符串值。"},
{"R_invalidValueForTVPWithSQLVariant","不支持使用包含空 sql_variant 列的 TVP。"},
{"R_invalidDataTypeSupportForSQLVariant","SQL_VARIANT 中出现异常的 TDS 类型“{0}”。"},
{"R_sslProtocolPropertyDescription","TLS、TLSv1、TLSv1.1 和 TLSv1.2 中的 SSL 协议标签。默认值为 TLS。"},
{"R_invalidSSLProtocol","SSL 协议 {0} 标签无效。仅支持 TLS、TLSv1、TLSv1.1 和 TLSv1.2。"},
{"R_cancelQueryTimeoutPropertyDescription","等待取消发送查询超时的秒数。"},
{"R_invalidCancelQueryTimeout","取消超时值 {0} 无效。"},
{"R_useBulkCopyForBatchInsertPropertyDescription","驱动程序是否将大容量复制 API 用于批量插入操作"},
{"R_UnknownDataClsTokenNumber","数据分类的令牌未知。"},
{"R_InvalidDataClsVersionNumber","数据分类的版本号 {0} 无效。"},
{"R_unknownUTF8SupportValue","UTF8 支持值未知。"},
{"R_unknownAzureSQLDNSCachingValue","Azure SQL DNS 缓存的未知值。"},
{"R_illegalWKT","已知文本非法。请确保已知文本有效。"},
{"R_illegalTypeForGeometry","Geometry 不支持 {0}。"},
{"R_illegalWKTposition","已知文本中 {0} 位置处的字符非法。"},
{"R_keyVaultProviderClientIdPropertyDescription","用于访问存储列加密主密钥的 Key Vault 的客户端 ID。"},
{"R_keyVaultProviderClientKeyPropertyDescription","用于访问存储列加密主密钥的 Key Vault 的客户端密钥。"},
{"R_keyStorePrincipalIdPropertyDescription","Azure Active Directory 的主体 ID。"},
{"R_MSALMissing","无法加载用于执行 {0} 身份验证的 MSAL4J Java 库。"},
{"R_DLLandMSALMissing","无法加载用于执行 {1} 身份验证的 {0} 和 MSAL4J Java 库。若要继续操作，请安装其中一个。"},
{"R_MSITokenFailureImds","MSI 令牌失败: 未能从 IMDS 获取访问令牌"},
{"R_MSITokenFailureImdsClientId","MSI 令牌失败: 未能从 IMDS 获取访问令牌，请验证 clientId。"},
{"R_MSITokenFailureUnexpected","MSI 令牌失败: 未能从 IMDS 获取访问令牌，发生意外错误。"},
{"R_MSITokenFailureEndpoint","MSI 令牌失败: 未能从 MSI 终结点中获取令牌"},
{"R_propertyNotSupported","Microsoft JDBC Driver for SQL Server 当前不支持属性: {0}"},
{"R_ntlmHmacMD5Error","无法初始化 NTLM 身份验证: HMAC-MD5 初始化错误。"},
{"R_ntlmSignatureError","NTLM 质询消息签名错误: {0}"},
{"R_ntlmMessageTypeError","NTLM 质询消息类型错误: {0}"},
{"R_ntlmAuthenticateError","构造身份验证消息时出现 NTLM 错误: {0}"},
{"R_ntlmNoTargetInfo","NTLM 质询消息缺少 TargetInfo。"},
{"R_ntlmUnknownValue","NTLM 质询消息 TargetInfo 错误: 未知值“{0}”"},
{"R_useFmtOnlyPropertyDescription","确定是否允许/禁止使用 SET FMTONLY 检索参数元数据。"},
{"R_invalidOpenqueryCall","语法无效: OPENQUERY/OPENJSON/OPENDATASOURCE/OPENROWSET/OPENXML 必须以圆括号开头"},
{"R_invalidCTEFormat","语法无效: 在公用表表达式中，AS 必须后跟圆括号。"},
{"R_noTokensFoundInUserQuery","查询无效: 未从提供的 SQL 中分析任何标记。"},
{"R_invalidUserSQL","尝试分析用户 SQL 时出错。请验证 SQL 语法。"},
{"R_invalidInsertValuesQuery","将 VALUES 列表与表列匹配时出错。请验证 SQL 语法。"},
{"R_invalidValuesList","读取 VALUES 列表时出错。请验证 SQL 语法。"},
{"R_enclaveNotSupported","SQL Server 实例不支持基于 enclave 的计算。"},
{"R_enclavePropertiesError","启用具有安全 enclave 的 Always Encrypted 时，必须启用 \"columnEncryptionSetting\" 连接属性以及有效的 \"enclaveAttestationUrl\" 和 \"enclaveAttestationProtocol\" 连接属性。"},
{"R_enclaveInvalidAttestationProtocol","\"enclaveAttestationProtocol\" 无效。"},
{"R_enclaveTypeInvalid","enclave 类型 {0} 无效或不受驱动程序支持。"},
{"R_attestationUrlInvalid","无法证明由 {0} 指定的 enclave。"},
{"R_EnclaveResponseLengthError","在分析 enclave 证明响应时，收到的来自服务器的字节数多于预期。"},
{"R_EnclavePackageLengthError","在分析 enclave 包时，收到的来自服务器的字节数多于预期。"},
{"R_EnclavePKLengthError","在分析 enclave 公钥时，收到的来自服务器的字节数多于预期。"},
{"R_MalformedECDHPublicKey","来自服务器的 ECDH 公钥的长度必须为 104 位。"},
{"R_MalformedECDHHeader","来自服务器的 ECDH 公钥标头的值异常。"},
{"R_HealthCertError","enclave 证明失败，无法检索 enclave {0} 中提供的运行状况报告证书。"},
{"R_InvalidHealthCert","enclave 证明失败，enclave 中提供的运行状况报告证书未由 HGS 签名。"},
{"R_InvalidSignedStatement","enclave 证明失败，运行状况证书未对语句字节进行签名。"},
{"R_InvalidDHKeySignature","enclave 证明失败，无法使用 enclave 公钥验证 DH 公钥签名。"},
{"R_AasJWTError","检索和验证 JSON Web 令牌时出错。"},
{"R_AasEhdError","来自 JWT 的 aas-ehd 声明与 enclave 公钥不匹配。"},
{"R_VbsRpDataError","来自 JWT 的 rp_data 声明与客户端 nonce 不匹配。"},
{"R_pvkParseError","无法从 PVK 读取私钥。请检查提供的密码。"},
{"R_pvkHeaderError","无法分析 PVK。PVK 文件没有包含正确的标头。"},
{"R_clientCertError","无法读取客户端证书。请验证证书的位置。"},
{"R_unassignableError","{0} 属性指定的类必须可分配给 {1}。"},
{"R_InvalidCSVQuotes","无法分析 CSV 文件。请验证是否将字段正确地放在双引号中。"},
{"R_TokenRequireUrl","令牌凭据需要使用 HTTPS 协议方案的 URL。"},
{"R_maxResultBufferPropertyDescription","确定在检索结果集期间可读取的最大字节量"},
{"R_maxResultBufferInvalidSyntax","语法无效: maxResultBuffer 参数中的 {0}。"},
{"R_maxResultBufferNegativeParameterValue","MaxResultBuffer 必须为正值: {0}。"},
{"R_maxResultBufferPropertyExceeded","超过了 MaxResultBuffer 属性: {0}。MaxResultBuffer 设置为 {1}。"},
};
}
