/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter;

import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.utils.StringHelper;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public final class AuthenticationToken {
    private String token;
    private DateTime expiryTime;
    private Duration expiryBuffer;

    public AuthenticationToken(String token, DateTime expiryTime) {
        if (StringHelper.isNullOrWhiteSpace(token)) {
            throw new IllegalArgumentException("token cannot be empty");
        }
        this.setToken(token);
        this.setExpiryTime(expiryTime);
        this.setExpiryBuffer(Duration.standardSeconds((long)PartnerService.getInstance().getConfiguration().getDefaultAuthenticationTokenExpiryBufferInSeconds()));
    }

    public String getToken() {
        return this.token;
    }

    private void setToken(String value) {
        this.token = value;
    }

    public DateTime getExpiryTime() {
        return this.expiryTime;
    }

    private void setExpiryTime(DateTime value) {
        this.expiryTime = value;
    }

    public Duration getExpiryBuffer() {
        return this.expiryBuffer;
    }

    public void setExpiryBuffer(Duration value) {
        this.expiryBuffer = value;
    }

    public boolean isExpired() {
        return DateTime.now().isAfter((ReadableInstant)this.getExpiryTime().minus((ReadableDuration)this.getExpiryBuffer()));
    }
}

