/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter;

import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.IPartnerCredentials;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.agreements.AgreementDetailsCollectionOperations;
import com.microsoft.store.partnercenter.agreements.IAgreementDetailsCollection;
import com.microsoft.store.partnercenter.analytics.IPartnerAnalyticsCollection;
import com.microsoft.store.partnercenter.analytics.PartnerAnalyticsCollectionOperations;
import com.microsoft.store.partnercenter.auditrecords.AuditRecordsCollection;
import com.microsoft.store.partnercenter.auditrecords.IAuditRecordsCollection;
import com.microsoft.store.partnercenter.compliance.ComplianceCollectionOperations;
import com.microsoft.store.partnercenter.compliance.IComplianceCollection;
import com.microsoft.store.partnercenter.countryvalidationrules.CountryValidationRulesCollectionOperations;
import com.microsoft.store.partnercenter.countryvalidationrules.ICountryValidationRulesCollection;
import com.microsoft.store.partnercenter.customers.CustomerCollectionOperations;
import com.microsoft.store.partnercenter.customers.ICustomerCollection;
import com.microsoft.store.partnercenter.domains.DomainCollectionOperations;
import com.microsoft.store.partnercenter.domains.IDomainCollection;
import com.microsoft.store.partnercenter.enumerators.IResourceCollectionEnumeratorContainer;
import com.microsoft.store.partnercenter.enumerators.ResourceCollectionEnumeratorContainer;
import com.microsoft.store.partnercenter.extensions.ExtensionsOperations;
import com.microsoft.store.partnercenter.extensions.IExtensions;
import com.microsoft.store.partnercenter.genericoperations.ICountrySelector;
import com.microsoft.store.partnercenter.invoices.IInvoiceCollection;
import com.microsoft.store.partnercenter.invoices.InvoiceCollection;
import com.microsoft.store.partnercenter.network.IPartnerServiceClient;
import com.microsoft.store.partnercenter.network.PartnerServiceClient;
import com.microsoft.store.partnercenter.offers.IOfferCategoryCollection;
import com.microsoft.store.partnercenter.offers.IOfferCollection;
import com.microsoft.store.partnercenter.offers.OfferCategoryCountrySelector;
import com.microsoft.store.partnercenter.offers.OfferCountrySelector;
import com.microsoft.store.partnercenter.products.IProductCollection;
import com.microsoft.store.partnercenter.products.ProductCollectionOperations;
import com.microsoft.store.partnercenter.productupgrades.IProductUpgradeCollection;
import com.microsoft.store.partnercenter.productupgrades.ProductUpgradeCollectionOperations;
import com.microsoft.store.partnercenter.profiles.IPartnerProfileCollection;
import com.microsoft.store.partnercenter.profiles.PartnerProfileCollectionOperations;
import com.microsoft.store.partnercenter.ratecards.IRateCardCollection;
import com.microsoft.store.partnercenter.ratecards.RateCardCollectionOperations;
import com.microsoft.store.partnercenter.relationships.IRelationshipCollection;
import com.microsoft.store.partnercenter.relationships.RelationshipCollectionOperations;
import com.microsoft.store.partnercenter.requestcontext.IRequestContext;
import com.microsoft.store.partnercenter.serviceincidents.IServiceIncidentCollection;
import com.microsoft.store.partnercenter.serviceincidents.ServiceIncidentCollectionOperations;
import com.microsoft.store.partnercenter.servicerequests.IPartnerServiceRequestCollection;
import com.microsoft.store.partnercenter.servicerequests.PartnerServiceRequestCollectionOperations;
import com.microsoft.store.partnercenter.usage.IPartnerUsageSummary;
import com.microsoft.store.partnercenter.usage.PartnerUsageSummaryOperations;
import com.microsoft.store.partnercenter.validations.IValidationOperations;
import com.microsoft.store.partnercenter.validations.ValidationOperations;

public class PartnerOperations
implements IPartner {
    private IComplianceCollection compliance;
    private IResourceCollectionEnumeratorContainer enumeratorContainer;
    private ICustomerCollection customers;
    private ICountrySelector<IOfferCategoryCollection> offerCategories;
    private ICountrySelector<IOfferCollection> offers;
    private IProductUpgradeCollection productUpgrades;
    private IPartnerProfileCollection profiles;
    private IInvoiceCollection invoices;
    private IPartnerServiceRequestCollection serviceRequests;
    private IServiceIncidentCollection serviceIncidents;
    private ICountryValidationRulesCollection countryValidationRules;
    private IPartnerUsageSummary usageSummary;
    private IDomainCollection domains;
    private IAuditRecordsCollection auditRecords;
    private IRateCardCollection rateCards;
    private IPartnerAnalyticsCollection analytics;
    private IExtensions extensions;
    private IProductCollection products;
    private IRelationshipCollection relationships;
    private IValidationOperations validations;
    private IAgreementDetailsCollection agreements;
    private IPartnerServiceClient serviceClient;
    private IPartnerCredentials credentials;
    private IRequestContext requestContext;

    public PartnerOperations(IPartnerCredentials credentials, IRequestContext context) {
        if (credentials == null) {
            throw new IllegalArgumentException("credentials can't be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.setCredentials(credentials);
        this.setRequestContext(context);
        this.serviceClient = new PartnerServiceClient(PartnerService.getInstance().getApiRootUrl());
    }

    @Override
    public IComplianceCollection getCompliance() {
        if (this.compliance == null) {
            this.compliance = new ComplianceCollectionOperations(this);
        }
        return this.compliance;
    }

    @Override
    public IPartnerCredentials getCredentials() {
        return this.credentials;
    }

    private void setCredentials(IPartnerCredentials value) {
        this.credentials = value;
    }

    @Override
    public IRequestContext getRequestContext() {
        return this.requestContext;
    }

    private void setRequestContext(IRequestContext value) {
        this.requestContext = value;
    }

    @Override
    public IResourceCollectionEnumeratorContainer getEnumerators() {
        if (this.enumeratorContainer == null) {
            this.enumeratorContainer = new ResourceCollectionEnumeratorContainer(this);
        }
        return this.enumeratorContainer;
    }

    @Override
    public ICountrySelector<IOfferCategoryCollection> getOfferCategories() {
        if (this.offerCategories == null) {
            this.offerCategories = new OfferCategoryCountrySelector(this);
        }
        return this.offerCategories;
    }

    @Override
    public IPartnerProfileCollection getProfiles() {
        if (this.profiles == null) {
            this.profiles = new PartnerProfileCollectionOperations(this);
        }
        return this.profiles;
    }

    @Override
    public ICustomerCollection getCustomers() {
        if (this.customers == null) {
            this.customers = new CustomerCollectionOperations(this);
        }
        return this.customers;
    }

    @Override
    public ICountrySelector<IOfferCollection> getOffers() {
        if (this.offers == null) {
            this.offers = new OfferCountrySelector(this);
        }
        return this.offers;
    }

    @Override
    public IInvoiceCollection getInvoices() {
        if (this.invoices == null) {
            this.invoices = new InvoiceCollection(this);
        }
        return this.invoices;
    }

    @Override
    public IPartnerServiceRequestCollection getServiceRequests() {
        if (this.serviceRequests == null) {
            this.serviceRequests = new PartnerServiceRequestCollectionOperations(this);
        }
        return this.serviceRequests;
    }

    @Override
    public IServiceIncidentCollection getServiceIncidents() {
        if (this.serviceIncidents == null) {
            this.serviceIncidents = new ServiceIncidentCollectionOperations(this);
        }
        return this.serviceIncidents;
    }

    @Override
    public IPartnerUsageSummary getUsageSummary() {
        if (this.usageSummary == null) {
            this.usageSummary = new PartnerUsageSummaryOperations(this);
        }
        return this.usageSummary;
    }

    @Override
    public IAuditRecordsCollection getAuditRecords() {
        if (this.auditRecords == null) {
            this.auditRecords = new AuditRecordsCollection(this);
        }
        return this.auditRecords;
    }

    @Override
    public ICountryValidationRulesCollection getCountryValidationRules() {
        if (this.countryValidationRules == null) {
            this.countryValidationRules = new CountryValidationRulesCollectionOperations(this);
        }
        return this.countryValidationRules;
    }

    @Override
    public IDomainCollection getDomains() {
        if (this.domains == null) {
            this.domains = new DomainCollectionOperations(this);
        }
        return this.domains;
    }

    @Override
    public IRateCardCollection getRateCards() {
        if (this.rateCards == null) {
            this.rateCards = new RateCardCollectionOperations(this);
        }
        return this.rateCards;
    }

    @Override
    public IPartnerAnalyticsCollection getAnalytics() {
        if (this.analytics == null) {
            this.analytics = new PartnerAnalyticsCollectionOperations(this);
        }
        return this.analytics;
    }

    @Override
    public IExtensions getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ExtensionsOperations(this);
        }
        return this.extensions;
    }

    @Override
    public IProductCollection getProducts() {
        if (this.products == null) {
            this.products = new ProductCollectionOperations(this);
        }
        return this.products;
    }

    @Override
    public IRelationshipCollection getRelationships() {
        if (this.relationships == null) {
            return new RelationshipCollectionOperations(this);
        }
        return this.relationships;
    }

    @Override
    public IValidationOperations getValidations() {
        if (this.validations == null) {
            this.validations = new ValidationOperations(this);
        }
        return this.validations;
    }

    @Override
    public IAgreementDetailsCollection getAgreementDetails() {
        if (this.agreements == null) {
            this.agreements = new AgreementDetailsCollectionOperations(this);
        }
        return this.agreements;
    }

    @Override
    public IProductUpgradeCollection getProductUpgrades() {
        if (this.productUpgrades == null) {
            this.productUpgrades = new ProductUpgradeCollectionOperations(this);
        }
        return this.productUpgrades;
    }

    @Override
    public IPartnerServiceClient getServiceClient() {
        return this.serviceClient;
    }
}

