/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.store.partnercenter.IAggregatePartner;
import com.microsoft.store.partnercenter.IPartnerCredentials;
import com.microsoft.store.partnercenter.configuration.Configuration;
import com.microsoft.store.partnercenter.exception.PartnerException;
import com.microsoft.store.partnercenter.factory.IPartnerFactory;
import com.microsoft.store.partnercenter.factory.StandardPartnerFactory;
import com.microsoft.store.partnercenter.logging.PartnerLog;
import com.microsoft.store.partnercenter.logging.SystemOutLogger;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.io.IOException;
import java.io.InputStream;

public class PartnerService {
    private static PartnerService instance = new PartnerService();
    private String apiRootUrl;
    private String partnerServiceApiVersion;
    private String applicationName;
    private Configuration configuration;
    private IPartnerFactory factory;
    private IPartnerCredentials refreshCredentialsHandler;
    private String proxyHostName;
    private Integer proxyPort;
    private String sdkVersion;

    private PartnerService() {
        this.setConfiguration(this.readPartnerServiceConfiguration());
        this.setApiRootUrl(this.configuration.getPartnerServiceApiRoot());
        this.setPartnerServiceApiVersion(this.configuration.getPartnerServiceApiVersion());
        this.setFactory(new StandardPartnerFactory());
        this.sdkVersion = this.configuration.getSdkVersion();
        PartnerLog.getInstance().getLoggers().add(new SystemOutLogger());
    }

    public static PartnerService getInstance() {
        return instance;
    }

    public String getApiRootUrl() {
        return this.apiRootUrl;
    }

    public void setApiRootUrl(String value) {
        this.apiRootUrl = value;
    }

    public String getPartnerServiceApiVersion() {
        return this.partnerServiceApiVersion;
    }

    private void setPartnerServiceApiVersion(String value) {
        this.partnerServiceApiVersion = value;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    private void setApplicationName(String value) {
        this.applicationName = value;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    private void setConfiguration(Configuration value) {
        this.configuration = value;
    }

    public IPartnerFactory getFactory() {
        return this.factory;
    }

    void setFactory(IPartnerFactory value) {
        this.factory = value;
    }

    public IPartnerCredentials getRefreshCredentialsHandler() {
        return this.refreshCredentialsHandler;
    }

    public void setRefreshCredentialsHandler(IPartnerCredentials partnerCredentials) {
        this.refreshCredentialsHandler = partnerCredentials;
    }

    public String getProxyHostName() {
        return this.proxyHostName;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public void setProxyOptions(String hostName, Integer port) {
        if (StringHelper.isNullOrWhiteSpace(hostName)) {
            throw new PartnerException("The hostName should be set");
        }
        this.proxyHostName = hostName;
        this.proxyPort = port;
    }

    public void clearProxyOptions() {
        this.proxyHostName = null;
        this.proxyPort = null;
    }

    public IAggregatePartner createPartnerOperations(IPartnerCredentials credentials) {
        return this.getFactory().build(credentials);
    }

    private Configuration readPartnerServiceConfiguration() {
        ObjectMapper mapper = new ObjectMapper();
        InputStream is = PartnerService.class.getClassLoader().getResourceAsStream("PartnerService.json");
        try {
            Configuration configuration = (Configuration)mapper.readValue(is, Configuration.class);
            return configuration;
        }
        catch (IOException ex) {
            throw new PartnerException("Problem reading PartnerSDK configuration file", ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                throw new PartnerException("There was an issue closing the stream.", ex);
            }
        }
    }
}

