/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.agreements;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.agreements.IAgreementDetailsCollection;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.agreements.AgreementMetaData;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.util.ArrayList;

public class AgreementDetailsCollectionOperations
extends BasePartnerComponentString
implements IAgreementDetailsCollection {
    private String agreementType;

    public AgreementDetailsCollectionOperations(IPartner rootPartnerOperations) {
        super(rootPartnerOperations);
    }

    public AgreementDetailsCollectionOperations(IPartner rootPartnerOperations, String agreementType) {
        super(rootPartnerOperations);
        if (StringHelper.isNullOrWhiteSpace(agreementType)) {
            throw new IllegalArgumentException("agreementType must be set");
        }
        this.agreementType = agreementType;
    }

    @Override
    public ResourceCollection<AgreementMetaData> get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        if (StringHelper.isNullOrWhiteSpace(this.agreementType)) {
            return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<AgreementMetaData>>(){}, PartnerService.getInstance().getConfiguration().getApis().get("GetAgreementsDetails").getPath());
        }
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetAgreementsDetails").getParameters().get("AgreementType"), this.agreementType));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<AgreementMetaData>>(){}, PartnerService.getInstance().getConfiguration().getApis().get("GetAgreementsDetails").getPath(), parameters);
    }

    @Override
    public IAgreementDetailsCollection byAgreementType(String agreementType) {
        return new AgreementDetailsCollectionOperations(this.getPartner(), agreementType);
    }
}

