/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.agreements;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.agreements.ICustomerAgreementCollection;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.agreements.Agreement;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class CustomerAgreementCollectionOperations
extends BasePartnerComponentString
implements ICustomerAgreementCollection {
    private String agreementType;

    public CustomerAgreementCollectionOperations(IPartner rootPartnerOperations, String customerId) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
    }

    public CustomerAgreementCollectionOperations(IPartner rootPartnerOperations, String customerId, String agreementType) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(agreementType)) {
            throw new IllegalArgumentException("agreementType must be set");
        }
        this.agreementType = agreementType;
    }

    @Override
    public Agreement create(Agreement newEntity) {
        if (newEntity == null) {
            throw new IllegalArgumentException("Agreement can't be null.");
        }
        return this.getPartner().getServiceClient().post(this.getPartner(), new TypeReference<Agreement>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("CreateCustomerAgreement").getPath(), this.getContext()), newEntity);
    }

    @Override
    public ResourceCollection<Agreement> get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        if (StringHelper.isNullOrWhiteSpace(this.agreementType)) {
            return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Agreement>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerAgreements").getPath(), this.getContext()));
        }
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerAgreements").getParameters().get("AgreementType"), this.agreementType));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Agreement>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerAgreements").getPath(), this.getContext()), parameters);
    }

    @Override
    public ICustomerAgreementCollection byAgreementType(String agreementType) {
        return new CustomerAgreementCollectionOperations(this.getPartner(), (String)this.getContext(), agreementType);
    }
}

