/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.applicationconsents;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.applicationconsents.ApplicationConsentOperations;
import com.microsoft.store.partnercenter.applicationconsents.IApplicationConsent;
import com.microsoft.store.partnercenter.applicationconsents.ICustomerApplicationConsentCollection;
import com.microsoft.store.partnercenter.models.applicationconsents.ApplicationConsent;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class CustomerApplicationConsentCollectionOperations
extends BasePartnerComponent<String>
implements ICustomerApplicationConsentCollection {
    public CustomerApplicationConsentCollectionOperations(IPartner rootPartnerOperations, String customerId) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
    }

    @Override
    public IApplicationConsent byId(String applicationId) {
        return new ApplicationConsentOperations(this.getPartner(), (String)this.getContext(), applicationId);
    }

    @Override
    public ApplicationConsent create(ApplicationConsent newApplicationConsent) {
        if (newApplicationConsent == null) {
            throw new IllegalArgumentException("Application consent can't be null.");
        }
        return this.getPartner().getServiceClient().post(this.getPartner(), new TypeReference<ApplicationConsent>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("CreateCustomerApplicationConsent").getPath(), this.getContext()), newApplicationConsent);
    }
}

