/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.carts;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.carts.CartOperations;
import com.microsoft.store.partnercenter.carts.ICart;
import com.microsoft.store.partnercenter.carts.ICartCollection;
import com.microsoft.store.partnercenter.models.carts.Cart;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class CartCollectionOperations
extends BasePartnerComponentString
implements ICartCollection {
    public CartCollectionOperations(IPartner rootPartnerOperations, String customerId) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
    }

    @Override
    public ICart byId(String cartId) {
        return new CartOperations(this.getPartner(), (String)this.getContext(), cartId);
    }

    @Override
    public Cart create(Cart newCart) {
        if (newCart == null) {
            throw new IllegalArgumentException("The newCart cannot be null");
        }
        return this.getPartner().getServiceClient().post(this.getPartner(), new TypeReference<Cart>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("CreateCart").getPath(), this.getContext()), newCart);
    }
}

