/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.carts;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.carts.ICart;
import com.microsoft.store.partnercenter.models.carts.Cart;
import com.microsoft.store.partnercenter.models.carts.CartCheckoutResult;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class CartOperations
extends BasePartnerComponent<Tuple<String, String>>
implements ICart {
    public CartOperations(IPartner rootPartnerOperations, String customerId, String cartId) {
        super(rootPartnerOperations, new Tuple<String, String>(customerId, cartId));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(cartId)) {
            throw new IllegalArgumentException("cartId must be set");
        }
    }

    @Override
    public CartCheckoutResult checkout() {
        return this.getPartner().getServiceClient().post(this.getPartner(), new TypeReference<CartCheckoutResult>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("PlaceOrder").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()), "success");
    }

    @Override
    public Cart get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<Cart>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCart").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()));
    }

    @Override
    public Cart put(Cart cart) {
        return this.getPartner().getServiceClient().put(this.getPartner(), new TypeReference<Cart>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("UpdateCart").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()), cart);
    }
}

