/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.customerdirectoryroles;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.customerdirectoryroles.DirectoryRoleOperations;
import com.microsoft.store.partnercenter.customerdirectoryroles.IDirectoryRole;
import com.microsoft.store.partnercenter.customerdirectoryroles.IDirectoryRoleCollection;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.roles.DirectoryRole;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class DirectoryRoleCollectionOperations
extends BasePartnerComponentString
implements IDirectoryRoleCollection {
    public DirectoryRoleCollectionOperations(IPartner rootPartnerOperations, String customerId) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrEmpty(customerId)) {
            throw new IllegalArgumentException("customerId must be set.");
        }
    }

    @Override
    public IDirectoryRole byId(String roleId) {
        return new DirectoryRoleOperations(this.getPartner(), (String)this.getContext(), roleId);
    }

    @Override
    public ResourceCollection<DirectoryRole> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<DirectoryRole>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerDirectoryRoles").getPath(), this.getContext()));
    }
}

