/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.customerdirectoryroles;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.customerdirectoryroles.IUserMember;
import com.microsoft.store.partnercenter.customerdirectoryroles.IUserMemberCollection;
import com.microsoft.store.partnercenter.customerdirectoryroles.UserMemberOperations;
import com.microsoft.store.partnercenter.models.SeekBasedResourceCollection;
import com.microsoft.store.partnercenter.models.query.IQuery;
import com.microsoft.store.partnercenter.models.query.QueryType;
import com.microsoft.store.partnercenter.models.roles.UserMember;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;

public class UserMemberCollectionOperations
extends BasePartnerComponent<Tuple<String, String>>
implements IUserMemberCollection {
    public UserMemberCollectionOperations(IPartner rootPartnerOperations, String customerId, String roleId) {
        super(rootPartnerOperations, new Tuple<String, String>(customerId, roleId));
        if (StringHelper.isNullOrEmpty(customerId)) {
            throw new IllegalArgumentException("customerId must be set.");
        }
        if (StringHelper.isNullOrEmpty(roleId)) {
            throw new IllegalArgumentException("roleId must be set.");
        }
    }

    @Override
    public IUserMember byId(String userId) {
        return new UserMemberOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2(), userId);
    }

    @Override
    public UserMember create(UserMember newEntity) {
        if (newEntity == null) {
            throw new IllegalArgumentException("The newEntity parameter cannot be null.");
        }
        return this.getPartner().getServiceClient().post(this.getPartner(), new TypeReference<UserMember>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("AddUserToCustomerDirectoryRole").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()), newEntity);
    }

    @Override
    public SeekBasedResourceCollection<UserMember> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<SeekBasedResourceCollection<UserMember>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerDirectoryRoleUserMembers").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()));
    }

    @Override
    public SeekBasedResourceCollection<UserMember> query(IQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("query can't be null");
        }
        if (query.getType() == QueryType.COUNT) {
            throw new IllegalArgumentException("query can't be a count query.");
        }
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (query.getType() == QueryType.SEEK) {
            if (query.getToken() == null) {
                throw new IllegalArgumentException("query.Token is required.");
            }
            headers.put(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerUsers").getAdditionalHeaders().get("ContinuationToken"), query.getToken().toString());
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerDirectoryRoleUserMembers").getParameters().get("SeekOperation"), query.getSeekOperation().toString()));
        } else if (query.getType() == QueryType.INDEXED) {
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerDirectoryRoleUserMembers").getParameters().get("Size"), String.valueOf(query.getPageSize())));
        } else {
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerDirectoryRoleUserMembers").getParameters().get("Size"), "0"));
        }
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<SeekBasedResourceCollection<UserMember>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerDirectoryRoleUserMembers").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()), headers, parameters);
    }
}

