/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.customers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.customers.CustomerOperations;
import com.microsoft.store.partnercenter.customers.ICustomer;
import com.microsoft.store.partnercenter.customers.ICustomerCollection;
import com.microsoft.store.partnercenter.exception.PartnerErrorCategory;
import com.microsoft.store.partnercenter.exception.PartnerException;
import com.microsoft.store.partnercenter.models.SeekBasedResourceCollection;
import com.microsoft.store.partnercenter.models.customers.Customer;
import com.microsoft.store.partnercenter.models.query.IQuery;
import com.microsoft.store.partnercenter.models.query.QueryType;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.relationshiprequests.CustomerRelationshipRequestOperations;
import com.microsoft.store.partnercenter.relationshiprequests.ICustomerRelationshipRequest;
import com.microsoft.store.partnercenter.usage.CustomerUsageRecordCollectionOperations;
import com.microsoft.store.partnercenter.usage.ICustomerUsageRecordCollection;
import com.microsoft.store.partnercenter.utils.ParameterValidator;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;

public class CustomerCollectionOperations
extends BasePartnerComponentString
implements ICustomerCollection {
    private static final int MIN_PAGE_SIZE = 1;
    private static final int MAX_PAGE_SIZE = 500;
    private ICustomerUsageRecordCollection usageRecords;
    private ICustomerRelationshipRequest relationshipRequest;

    public CustomerCollectionOperations(IPartner rootPartnerOperations) {
        super(rootPartnerOperations);
    }

    @Override
    public ICustomerUsageRecordCollection getUsageRecords() {
        if (this.usageRecords == null) {
            this.usageRecords = new CustomerUsageRecordCollectionOperations(this.getPartner());
        }
        return this.usageRecords;
    }

    @Override
    public ICustomerRelationshipRequest getRelationshipRequests() {
        if (this.relationshipRequest == null) {
            this.relationshipRequest = new CustomerRelationshipRequestOperations(this.getPartner());
        }
        return this.relationshipRequest;
    }

    @Override
    public ICustomer byId(String customerId) {
        return new CustomerOperations(this.getPartner(), customerId);
    }

    @Override
    public Customer create(Customer newCustomer) {
        if (newCustomer == null) {
            throw new IllegalArgumentException("The newCustomer parameter cannot be null.");
        }
        return this.getPartner().getServiceClient().post(this.getPartner(), new TypeReference<Customer>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("CreateCustomer").getPath(), this.getContext()), newCustomer);
    }

    @Override
    public SeekBasedResourceCollection<Customer> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<SeekBasedResourceCollection<Customer>>(){}, PartnerService.getInstance().getConfiguration().getApis().get("GetCustomers").getPath());
    }

    @Override
    public SeekBasedResourceCollection<Customer> query(IQuery customersQuery) {
        if (customersQuery == null) {
            throw new IllegalArgumentException("customersQuery can't be null");
        }
        if (customersQuery.getType() == QueryType.COUNT) {
            throw new IllegalArgumentException("customersQuery can't be a count query.");
        }
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (customersQuery.getType() == QueryType.SEEK) {
            if (customersQuery.getToken() == null) {
                throw new IllegalArgumentException("customersQuery.Token is required.");
            }
            headers.put(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomers").getAdditionalHeaders().get("ContinuationToken"), customersQuery.getToken().toString());
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomers").getParameters().get("SeekOperation"), customersQuery.getSeekOperation().toString()));
        } else {
            if (customersQuery.getType() == QueryType.INDEXED) {
                ParameterValidator.isIntInclusive(1, 500, customersQuery.getPageSize(), MessageFormat.format("Allowed page size values are from {0}-{1}", 1, 500));
                parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomers").getParameters().get("Size"), String.valueOf(customersQuery.getPageSize())));
            } else {
                parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomers").getParameters().get("Size"), "0"));
            }
            if (customersQuery.getFilter() != null) {
                ObjectMapper mapper = new ObjectMapper();
                try {
                    parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomers").getParameters().get("Filter"), URLEncoder.encode(mapper.writeValueAsString((Object)customersQuery.getFilter()), "UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new PartnerException("", null, PartnerErrorCategory.REQUEST_PARSING, (Exception)e);
                }
                catch (JsonProcessingException e) {
                    throw new PartnerException("", null, PartnerErrorCategory.REQUEST_PARSING, (Exception)((Object)e));
                }
            }
        }
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<SeekBasedResourceCollection<Customer>>(){}, PartnerService.getInstance().getConfiguration().getApis().get("GetCustomers").getPath(), headers, parameters);
    }
}

