/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.customers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.agreements.CustomerAgreementCollectionOperations;
import com.microsoft.store.partnercenter.agreements.ICustomerAgreementCollection;
import com.microsoft.store.partnercenter.analytics.CustomerAnalyticsCollectionOperations;
import com.microsoft.store.partnercenter.analytics.ICustomerAnalyticsCollection;
import com.microsoft.store.partnercenter.applicationconsents.CustomerApplicationConsentCollectionOperations;
import com.microsoft.store.partnercenter.applicationconsents.ICustomerApplicationConsentCollection;
import com.microsoft.store.partnercenter.carts.CartCollectionOperations;
import com.microsoft.store.partnercenter.carts.ICartCollection;
import com.microsoft.store.partnercenter.customerdirectoryroles.DirectoryRoleCollectionOperations;
import com.microsoft.store.partnercenter.customerdirectoryroles.IDirectoryRoleCollection;
import com.microsoft.store.partnercenter.customers.ICustomer;
import com.microsoft.store.partnercenter.customers.products.CustomerProductCollectionOperations;
import com.microsoft.store.partnercenter.customers.products.ICustomerProductCollection;
import com.microsoft.store.partnercenter.customers.profiles.CustomerProfileCollectionOperations;
import com.microsoft.store.partnercenter.customers.profiles.ICustomerProfileCollection;
import com.microsoft.store.partnercenter.customers.servicecosts.CustomerServiceCostsCollectionOperations;
import com.microsoft.store.partnercenter.customers.servicecosts.ICustomerServiceCostsCollection;
import com.microsoft.store.partnercenter.customerusers.CustomerUsersCollectionOperations;
import com.microsoft.store.partnercenter.customerusers.ICustomerUserCollection;
import com.microsoft.store.partnercenter.devicesdeployment.BatchJobStatusCollectionOperations;
import com.microsoft.store.partnercenter.devicesdeployment.ConfigurationPolicyCollectionOperations;
import com.microsoft.store.partnercenter.devicesdeployment.CustomerDevicesCollectionOperations;
import com.microsoft.store.partnercenter.devicesdeployment.DevicesBatchCollectionOperations;
import com.microsoft.store.partnercenter.devicesdeployment.IBatchJobStatusCollection;
import com.microsoft.store.partnercenter.devicesdeployment.IConfigurationPolicyCollection;
import com.microsoft.store.partnercenter.devicesdeployment.ICustomerDeviceCollection;
import com.microsoft.store.partnercenter.devicesdeployment.IDevicesBatchCollection;
import com.microsoft.store.partnercenter.entitlements.EntitlementCollectionOperations;
import com.microsoft.store.partnercenter.entitlements.IEntitlementCollection;
import com.microsoft.store.partnercenter.managedservices.IManagedServiceCollection;
import com.microsoft.store.partnercenter.managedservices.ManagedServiceCollectionOperations;
import com.microsoft.store.partnercenter.models.customers.Customer;
import com.microsoft.store.partnercenter.offers.CustomerOfferCategoryCollectionOperations;
import com.microsoft.store.partnercenter.offers.CustomerOfferCollectionOperations;
import com.microsoft.store.partnercenter.offers.ICustomerOfferCategoryCollection;
import com.microsoft.store.partnercenter.offers.ICustomerOfferCollection;
import com.microsoft.store.partnercenter.orders.IOrderCollection;
import com.microsoft.store.partnercenter.orders.OrderCollectionOperations;
import com.microsoft.store.partnercenter.qualification.CustomerQualificationOperations;
import com.microsoft.store.partnercenter.qualification.ICustomerQualification;
import com.microsoft.store.partnercenter.relationships.CustomerRelationshipCollectionOperations;
import com.microsoft.store.partnercenter.relationships.ICustomerRelationshipCollection;
import com.microsoft.store.partnercenter.servicerequests.CustomerServiceRequestCollectionOperations;
import com.microsoft.store.partnercenter.servicerequests.IServiceRequestCollection;
import com.microsoft.store.partnercenter.subscribedskus.CustomerSubscribedSkuCollectionOperations;
import com.microsoft.store.partnercenter.subscribedskus.ICustomerSubscribedSkuCollection;
import com.microsoft.store.partnercenter.subscriptions.ISubscriptionCollection;
import com.microsoft.store.partnercenter.subscriptions.SubscriptionCollectionOperations;
import com.microsoft.store.partnercenter.usage.CustomerUsageSpendingBudgetOperations;
import com.microsoft.store.partnercenter.usage.CustomerUsageSummaryOperations;
import com.microsoft.store.partnercenter.usage.ICustomerUsageSpendingBudget;
import com.microsoft.store.partnercenter.usage.ICustomerUsageSummary;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class CustomerOperations
extends BasePartnerComponentString
implements ICustomer {
    private ISubscriptionCollection subscriptions;
    private ICustomerAgreementCollection agreements;
    private ICustomerApplicationConsentCollection applicationConsents;
    private IOrderCollection orders;
    private ICustomerProfileCollection profiles;
    private IServiceRequestCollection serviceRequests;
    private IManagedServiceCollection managedServices;
    private ICustomerOfferCollection offers;
    private ICustomerOfferCategoryCollection offerCategories;
    private ICustomerUsageSummary usageSummary;
    private ICustomerUsageSpendingBudget usageBudget;
    private ICustomerQualification customerQualification;
    private ICustomerUserCollection customerUserCollectionOperations;
    private IDirectoryRoleCollection directoryRoleCollectionOperations;
    private ICustomerSubscribedSkuCollection customerSubscribedSkuCollectionOperations;
    private ICartCollection cartOperations;
    private ICustomerProductCollection productOperations;
    private ICustomerServiceCostsCollection serviceCostsOperations;
    private IDevicesBatchCollection deviceBatches;
    private ICustomerDeviceCollection devices;
    private IBatchJobStatusCollection batchUploadStatusCollection;
    private ICustomerRelationshipCollection customerRelationshipCollectionOperations;
    private ICustomerAnalyticsCollection analytics;
    private IEntitlementCollection entitlements;
    private IConfigurationPolicyCollection configurationPolicies;
    private String customerId;

    public CustomerOperations(IPartner rootPartnerOperations, String customerId) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
        this.customerId = customerId;
    }

    @Override
    public ICustomerAgreementCollection getAgreements() {
        if (this.agreements == null) {
            this.agreements = new CustomerAgreementCollectionOperations(this.getPartner(), this.customerId);
        }
        return this.agreements;
    }

    @Override
    public ICustomerApplicationConsentCollection getApplicationConsents() {
        if (this.applicationConsents == null) {
            this.applicationConsents = new CustomerApplicationConsentCollectionOperations(this.getPartner(), this.customerId);
        }
        return this.applicationConsents;
    }

    @Override
    public IOrderCollection getOrders() {
        if (this.orders == null) {
            this.orders = new OrderCollectionOperations(this.getPartner(), (String)this.getContext());
        }
        return this.orders;
    }

    @Override
    public ICustomerProfileCollection getProfiles() {
        if (this.profiles == null) {
            this.profiles = new CustomerProfileCollectionOperations(this.getPartner(), (String)this.getContext());
        }
        return this.profiles;
    }

    @Override
    public ISubscriptionCollection getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new SubscriptionCollectionOperations(this.getPartner(), (String)this.getContext());
        }
        return this.subscriptions;
    }

    @Override
    public IServiceRequestCollection getServiceRequests() {
        if (this.serviceRequests == null) {
            this.serviceRequests = new CustomerServiceRequestCollectionOperations(this.getPartner(), this.customerId);
        }
        return this.serviceRequests;
    }

    @Override
    public IManagedServiceCollection getManagedServices() {
        if (this.managedServices == null) {
            this.managedServices = new ManagedServiceCollectionOperations(this.getPartner(), this.customerId);
        }
        return this.managedServices;
    }

    @Override
    public ICustomerOfferCategoryCollection getOfferCategories() {
        if (this.offerCategories == null) {
            this.offerCategories = new CustomerOfferCategoryCollectionOperations(this.getPartner(), this.customerId);
        }
        return this.offerCategories;
    }

    @Override
    public ICustomerOfferCollection getOffers() {
        if (this.offers == null) {
            this.offers = new CustomerOfferCollectionOperations(this.getPartner(), this.customerId);
        }
        return this.offers;
    }

    @Override
    public ICustomerUsageSummary getUsageSummary() {
        if (this.usageSummary == null) {
            this.usageSummary = new CustomerUsageSummaryOperations(this.getPartner(), this.customerId);
        }
        return this.usageSummary;
    }

    @Override
    public ICustomerUsageSpendingBudget getUsageBudget() {
        if (this.usageBudget == null) {
            this.usageBudget = new CustomerUsageSpendingBudgetOperations(this.getPartner(), this.customerId);
        }
        return this.usageBudget;
    }

    @Override
    public ICustomerQualification getQualification() {
        if (this.customerQualification == null) {
            this.customerQualification = new CustomerQualificationOperations(this.getPartner(), this.customerId);
        }
        return this.customerQualification;
    }

    @Override
    public ICustomerUserCollection getUsers() {
        if (this.customerUserCollectionOperations == null) {
            this.customerUserCollectionOperations = new CustomerUsersCollectionOperations(this.getPartner(), this.customerId);
        }
        return this.customerUserCollectionOperations;
    }

    @Override
    public IDirectoryRoleCollection getDirectoryRoles() {
        if (this.directoryRoleCollectionOperations == null) {
            this.directoryRoleCollectionOperations = new DirectoryRoleCollectionOperations(this.getPartner(), this.customerId);
        }
        return this.directoryRoleCollectionOperations;
    }

    @Override
    public ICustomerSubscribedSkuCollection getSubscribedSkus() {
        if (this.customerSubscribedSkuCollectionOperations == null) {
            this.customerSubscribedSkuCollectionOperations = new CustomerSubscribedSkuCollectionOperations(this.getPartner(), this.customerId);
        }
        return this.customerSubscribedSkuCollectionOperations;
    }

    @Override
    public ICartCollection getCarts() {
        if (this.cartOperations == null) {
            this.cartOperations = new CartCollectionOperations(this.getPartner(), (String)this.getContext());
        }
        return this.cartOperations;
    }

    @Override
    public ICustomerProductCollection getProducts() {
        if (this.productOperations == null) {
            this.productOperations = new CustomerProductCollectionOperations(this.getPartner(), (String)this.getContext());
        }
        return this.productOperations;
    }

    @Override
    public ICustomerServiceCostsCollection getServiceCosts() {
        if (this.serviceCostsOperations == null) {
            this.serviceCostsOperations = new CustomerServiceCostsCollectionOperations(this.getPartner(), (String)this.getContext());
        }
        return this.serviceCostsOperations;
    }

    @Override
    public IDevicesBatchCollection getDeviceBatches() {
        if (this.deviceBatches == null) {
            this.deviceBatches = new DevicesBatchCollectionOperations(this.getPartner(), (String)this.getContext());
        }
        return this.deviceBatches;
    }

    @Override
    public ICustomerDeviceCollection getDevicePolicy() {
        if (this.devices == null) {
            this.devices = new CustomerDevicesCollectionOperations(this.getPartner(), (String)this.getContext());
        }
        return this.devices;
    }

    @Override
    public IBatchJobStatusCollection getBatchUploadStatus() {
        if (this.batchUploadStatusCollection == null) {
            this.batchUploadStatusCollection = new BatchJobStatusCollectionOperations(this.getPartner(), (String)this.getContext());
        }
        return this.batchUploadStatusCollection;
    }

    @Override
    public ICustomerRelationshipCollection getRelationships() {
        if (this.customerRelationshipCollectionOperations == null) {
            this.customerRelationshipCollectionOperations = new CustomerRelationshipCollectionOperations(this.getPartner(), (String)this.getContext());
        }
        return this.customerRelationshipCollectionOperations;
    }

    @Override
    public ICustomerAnalyticsCollection getAnalytics() {
        if (this.analytics == null) {
            this.analytics = new CustomerAnalyticsCollectionOperations(this.getPartner(), (String)this.getContext());
        }
        return this.analytics;
    }

    @Override
    public IEntitlementCollection getEntitlements() {
        if (this.entitlements == null) {
            this.entitlements = new EntitlementCollectionOperations(this.getPartner(), (String)this.getContext());
        }
        return this.entitlements;
    }

    @Override
    public IConfigurationPolicyCollection getConfigurationPolicies() {
        if (this.configurationPolicies == null) {
            this.configurationPolicies = new ConfigurationPolicyCollectionOperations(this.getPartner(), (String)this.getContext());
        }
        return this.configurationPolicies;
    }

    @Override
    public Customer get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<Customer>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomer").getPath(), this.getContext()));
    }

    @Override
    public Customer patch(Customer customer) {
        return this.getPartner().getServiceClient().patch(this.getPartner(), new TypeReference<Customer>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("RemoveCustomerRelationship").getPath(), this.getContext()), customer);
    }

    @Override
    public void delete() {
        this.getPartner().getServiceClient().delete(this.getPartner(), new TypeReference<Customer>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("DeleteCustomer").getPath(), this.getContext()));
    }
}

