/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.customers.products;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.products.Availability;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.QuintupleTuple;
import com.microsoft.store.partnercenter.products.IAvailabilityCollectionByTargetSegmentByReservationScopeOperations;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class CustomerAvailabilityCollectionByTargetSegmentByReservationScopeOperations
extends BasePartnerComponent<QuintupleTuple<String, String, String, String, String>>
implements IAvailabilityCollectionByTargetSegmentByReservationScopeOperations {
    protected CustomerAvailabilityCollectionByTargetSegmentByReservationScopeOperations(IPartner rootPartnerOperations, String customerId, String productId, String skuId, String targetSegment, String reservationScope) {
        super(rootPartnerOperations, new QuintupleTuple<String, String, String, String, String>(customerId, productId, skuId, targetSegment, reservationScope));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(productId)) {
            throw new IllegalArgumentException("productId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(skuId)) {
            throw new IllegalArgumentException("skuId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(targetSegment)) {
            throw new IllegalArgumentException("targetSegment must be set");
        }
        if (StringHelper.isNullOrEmpty(reservationScope)) {
            throw new IllegalArgumentException("reservationScope must be set");
        }
    }

    @Override
    public ResourceCollection<Availability> get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerProducts").getParameters().get("ReservationScope"), (String)((QuintupleTuple)this.getContext()).getItem5()));
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerProducts").getParameters().get("TargetSegment"), (String)((QuintupleTuple)this.getContext()).getItem4()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Availability>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerProducts").getPath(), ((QuintupleTuple)this.getContext()).getItem1(), ((QuintupleTuple)this.getContext()).getItem2(), ((QuintupleTuple)this.getContext()).getItem3()), parameters);
    }
}

