/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.customers.products;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.customers.products.CustomerAvailabilityCollectionByTargetSegmentOperations;
import com.microsoft.store.partnercenter.customers.products.CustomerAvailabilityOperations;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.products.Availability;
import com.microsoft.store.partnercenter.models.utils.TripletTuple;
import com.microsoft.store.partnercenter.products.IAvailability;
import com.microsoft.store.partnercenter.products.IAvailabilityCollection;
import com.microsoft.store.partnercenter.products.IAvailabilityCollectionByTargetSegment;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class CustomerAvailabilityCollectionOperations
extends BasePartnerComponent<TripletTuple<String, String, String>>
implements IAvailabilityCollection {
    public CustomerAvailabilityCollectionOperations(IPartner rootPartnerOperations, String customerId, String productId, String skuId) {
        super(rootPartnerOperations, new TripletTuple<String, String, String>(customerId, productId, skuId));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(productId)) {
            throw new IllegalArgumentException("productId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(skuId)) {
            throw new IllegalArgumentException("skuId must be set");
        }
    }

    @Override
    public IAvailability byId(String availabilityId) {
        return new CustomerAvailabilityOperations(this.getPartner(), (String)((TripletTuple)this.getContext()).getItem1(), (String)((TripletTuple)this.getContext()).getItem2(), (String)((TripletTuple)this.getContext()).getItem3(), availabilityId);
    }

    @Override
    public ResourceCollection<Availability> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Availability>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerAvailabilities").getPath(), ((TripletTuple)this.getContext()).getItem1(), ((TripletTuple)this.getContext()).getItem2(), ((TripletTuple)this.getContext()).getItem3()));
    }

    @Override
    public IAvailabilityCollectionByTargetSegment byTargetSegment(String targetSegment) {
        return new CustomerAvailabilityCollectionByTargetSegmentOperations(this.getPartner(), (String)((TripletTuple)this.getContext()).getItem1(), (String)((TripletTuple)this.getContext()).getItem2(), (String)((TripletTuple)this.getContext()).getItem3(), targetSegment);
    }
}

