/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.customers.products;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.customers.products.CustomerProductCollectionByTargetViewByReservationScopeOperations;
import com.microsoft.store.partnercenter.customers.products.CustomerProductCollectionByTargetViewByTargetSegmentOperations;
import com.microsoft.store.partnercenter.customers.products.ICustomerProductCollectionByTargetView;
import com.microsoft.store.partnercenter.customers.products.ICustomerProductCollectionByTargetViewByReservationScope;
import com.microsoft.store.partnercenter.customers.products.ICustomerProductCollectionByTargetViewByTargetSegment;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.products.Product;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class CustomerProductCollectionByTargetViewOperations
extends BasePartnerComponent<Tuple<String, String>>
implements ICustomerProductCollectionByTargetView {
    public CustomerProductCollectionByTargetViewOperations(IPartner rootPartnerOperations, String customerId, String targetView) {
        super(rootPartnerOperations, new Tuple<String, String>(customerId, targetView));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(targetView)) {
            throw new IllegalArgumentException("targetView must be set");
        }
    }

    @Override
    public ICustomerProductCollectionByTargetViewByReservationScope byReservationScope(String reservationScope) {
        return new CustomerProductCollectionByTargetViewByReservationScopeOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2(), reservationScope);
    }

    @Override
    public ICustomerProductCollectionByTargetViewByTargetSegment byTargetSegment(String targetSegment) {
        return new CustomerProductCollectionByTargetViewByTargetSegmentOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), targetSegment, (String)((Tuple)this.getContext()).getItem2());
    }

    @Override
    public ResourceCollection<Product> get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerProducts").getParameters().get("TargetView"), (String)((Tuple)this.getContext()).getItem2()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Product>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerProducts").getPath(), ((Tuple)this.getContext()).getItem1()), parameters);
    }
}

