/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.customers.products;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.customers.products.CustomerSkuCollectionOperations;
import com.microsoft.store.partnercenter.models.products.Product;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.products.IProduct;
import com.microsoft.store.partnercenter.products.ISkuCollection;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class CustomerProductOperations
extends BasePartnerComponent<Tuple<String, String>>
implements IProduct {
    private ISkuCollection skus;

    public CustomerProductOperations(IPartner rootPartnerOperations, String customerId, String productId) {
        super(rootPartnerOperations, new Tuple<String, String>(customerId, productId));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(productId)) {
            throw new IllegalArgumentException("productId must be set");
        }
    }

    @Override
    public Product get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<Product>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerProduct").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()));
    }

    @Override
    public ISkuCollection getSkus() {
        if (this.skus == null) {
            this.skus = new CustomerSkuCollectionOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2());
        }
        return this.skus;
    }
}

