/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.customers.products;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.products.Sku;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.TripletTuple;
import com.microsoft.store.partnercenter.products.ISkuCollectionByTargetSegment;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class CustomerSkuCollectionByTargetSegmentOperations
extends BasePartnerComponent<TripletTuple<String, String, String>>
implements ISkuCollectionByTargetSegment {
    public CustomerSkuCollectionByTargetSegmentOperations(IPartner rootPartnerOperations, String customerId, String productId, String targetSegment) {
        super(rootPartnerOperations, new TripletTuple<String, String, String>(customerId, productId, targetSegment));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(productId)) {
            throw new IllegalArgumentException("productId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(targetSegment)) {
            throw new IllegalArgumentException("targetSegment must be set");
        }
    }

    @Override
    public ResourceCollection<Sku> get() {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerSkus").getParameters().get("TargetSegment"), (String)((TripletTuple)this.getContext()).getItem3()));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Sku>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerSkus").getPath(), ((TripletTuple)this.getContext()).getItem1(), ((TripletTuple)this.getContext()).getItem2()), parameters);
    }
}

