/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.customers.products;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.customers.products.CustomerSkuCollectionByTargetSegmentOperations;
import com.microsoft.store.partnercenter.customers.products.CustomerSkuOperations;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.products.Sku;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.products.ISku;
import com.microsoft.store.partnercenter.products.ISkuCollection;
import com.microsoft.store.partnercenter.products.ISkuCollectionByTargetSegment;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class CustomerSkuCollectionOperations
extends BasePartnerComponent<Tuple<String, String>>
implements ISkuCollection {
    public CustomerSkuCollectionOperations(IPartner rootPartnerOperations, String customerId, String productId) {
        super(rootPartnerOperations, new Tuple<String, String>(customerId, productId));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(productId)) {
            throw new IllegalArgumentException("productId must be set");
        }
    }

    @Override
    public ISku byId(String skuId) {
        return new CustomerSkuOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2(), skuId);
    }

    @Override
    public ISkuCollectionByTargetSegment byTargetSegment(String targetSegment) {
        return new CustomerSkuCollectionByTargetSegmentOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2(), targetSegment);
    }

    @Override
    public ResourceCollection<Sku> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Sku>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerSkus").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()));
    }
}

