/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.customers.products;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.customers.products.CustomerAvailabilityCollectionOperations;
import com.microsoft.store.partnercenter.models.products.Sku;
import com.microsoft.store.partnercenter.models.utils.TripletTuple;
import com.microsoft.store.partnercenter.products.IAvailabilityCollection;
import com.microsoft.store.partnercenter.products.ISku;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class CustomerSkuOperations
extends BasePartnerComponent<TripletTuple<String, String, String>>
implements ISku {
    private IAvailabilityCollection availabilities;

    public CustomerSkuOperations(IPartner rootPartnerOperations, String customerId, String productId, String skuId) {
        super(rootPartnerOperations, new TripletTuple<String, String, String>(customerId, productId, skuId));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(productId)) {
            throw new IllegalArgumentException("productId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(skuId)) {
            throw new IllegalArgumentException("skuId must be set");
        }
    }

    @Override
    public IAvailabilityCollection getAvailabilities() {
        if (this.availabilities == null) {
            this.availabilities = new CustomerAvailabilityCollectionOperations(this.getPartner(), (String)((TripletTuple)this.getContext()).getItem1(), (String)((TripletTuple)this.getContext()).getItem2(), (String)((TripletTuple)this.getContext()).getItem3());
        }
        return this.availabilities;
    }

    @Override
    public Sku get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<Sku>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerSku").getPath(), ((TripletTuple)this.getContext()).getItem1(), ((TripletTuple)this.getContext()).getItem2(), ((TripletTuple)this.getContext()).getItem3()));
    }
}

