/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.customers.profiles;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.customers.profiles.ICustomerProfile;
import com.microsoft.store.partnercenter.models.customers.CustomerBillingProfile;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class CustomerBillingProfileOperations
extends BasePartnerComponentString
implements ICustomerProfile<CustomerBillingProfile> {
    public CustomerBillingProfileOperations(IPartner rootPartnerOperations, String customerId) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId can't be null");
        }
    }

    @Override
    public CustomerBillingProfile get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<CustomerBillingProfile>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerBillingProfile").getPath(), this.getContext()));
    }

    @Override
    public CustomerBillingProfile update(CustomerBillingProfile billingProfile) {
        if (billingProfile == null) {
            throw new IllegalArgumentException("billingProfile null");
        }
        return this.getPartner().getServiceClient().put(this.getPartner(), new TypeReference<CustomerBillingProfile>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("UpdateCustomerBillingProfile").getPath(), this.getContext()), billingProfile);
    }
}

