/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.customers.profiles;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.customers.profiles.ICustomerReadonlyProfile;
import com.microsoft.store.partnercenter.models.customers.CustomerCompanyProfile;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class CustomerCompanyProfileOperations
extends BasePartnerComponentString
implements ICustomerReadonlyProfile<CustomerCompanyProfile> {
    public CustomerCompanyProfileOperations(IPartner rootPartnerOperations, String customerId) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId cannot be null");
        }
    }

    @Override
    public CustomerCompanyProfile get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<CustomerCompanyProfile>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerCompanyProfile").getPath(), this.getContext()));
    }
}

