/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.customers.profiles;

import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.customers.profiles.CustomerBillingProfileOperations;
import com.microsoft.store.partnercenter.customers.profiles.CustomerCompanyProfileOperations;
import com.microsoft.store.partnercenter.customers.profiles.ICustomerProfile;
import com.microsoft.store.partnercenter.customers.profiles.ICustomerProfileCollection;
import com.microsoft.store.partnercenter.customers.profiles.ICustomerReadonlyProfile;
import com.microsoft.store.partnercenter.models.customers.CustomerBillingProfile;
import com.microsoft.store.partnercenter.models.customers.CustomerCompanyProfile;
import com.microsoft.store.partnercenter.utils.StringHelper;

public class CustomerProfileCollectionOperations
extends BasePartnerComponentString
implements ICustomerProfileCollection {
    private ICustomerProfile<CustomerBillingProfile> billingProfileOperations;
    private ICustomerReadonlyProfile<CustomerCompanyProfile> companyProfileOperations;

    public CustomerProfileCollectionOperations(IPartner rootPartnerOperations, String customerId) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId can't be null");
        }
    }

    @Override
    public ICustomerProfile<CustomerBillingProfile> getBilling() {
        if (this.billingProfileOperations == null) {
            this.billingProfileOperations = new CustomerBillingProfileOperations(this.getPartner(), (String)this.getContext());
        }
        return this.billingProfileOperations;
    }

    @Override
    public ICustomerReadonlyProfile<CustomerCompanyProfile> getCompany() {
        if (this.companyProfileOperations == null) {
            this.companyProfileOperations = new CustomerCompanyProfileOperations(this.getPartner(), (String)this.getContext());
        }
        return this.companyProfileOperations;
    }
}

