/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.customers.servicecosts;

import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.customers.servicecosts.IServiceCostLineItemsCollection;
import com.microsoft.store.partnercenter.customers.servicecosts.IServiceCostSummary;
import com.microsoft.store.partnercenter.customers.servicecosts.IServiceCostsCollection;
import com.microsoft.store.partnercenter.customers.servicecosts.ServiceCostLineItemsOperations;
import com.microsoft.store.partnercenter.customers.servicecosts.ServiceCostSummaryOperations;
import com.microsoft.store.partnercenter.models.servicecosts.ServiceCostsBillingPeriod;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.utils.StringHelper;

public class ServiceCostsCollectionOperations
extends BasePartnerComponent<Tuple<String, String>>
implements IServiceCostsCollection {
    private IServiceCostLineItemsCollection serviceCostLineItems;
    private IServiceCostSummary serviceCostSummary;

    public ServiceCostsCollectionOperations(IPartner rootPartnerOperations, String customerId, ServiceCostsBillingPeriod billingPeriod) {
        super(rootPartnerOperations, new Tuple<String, String>(customerId, billingPeriod.toString()));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
    }

    @Override
    public IServiceCostLineItemsCollection getLineItems() {
        if (this.serviceCostLineItems == null) {
            this.serviceCostLineItems = new ServiceCostLineItemsOperations(this.getPartner(), (Tuple)this.getContext());
        }
        return this.serviceCostLineItems;
    }

    @Override
    public IServiceCostSummary getSummary() {
        if (this.serviceCostSummary == null) {
            this.serviceCostSummary = new ServiceCostSummaryOperations(this.getPartner(), (Tuple)this.getContext());
        }
        return this.serviceCostSummary;
    }
}

