/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.customerusers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.customerusers.ICustomerUserLicenseCollection;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.licenses.License;
import com.microsoft.store.partnercenter.models.licenses.LicenseGroupId;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class CustomerUserLicenseCollectionOperations
extends BasePartnerComponent<Tuple<String, String>>
implements ICustomerUserLicenseCollection {
    public CustomerUserLicenseCollectionOperations(IPartner rootPartnerOperations, String customerId, String userId) {
        super(rootPartnerOperations, new Tuple<String, String>(customerId, userId));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId can't be null");
        }
        if (StringHelper.isNullOrWhiteSpace(userId)) {
            throw new IllegalArgumentException("userId can't be null");
        }
    }

    @Override
    public ResourceCollection<License> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<License>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerUserAssignedLicenses").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()));
    }

    @Override
    public ResourceCollection<License> get(List<LicenseGroupId> licenseGroupIds) {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        for (LicenseGroupId groupId : licenseGroupIds) {
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerUserAssignedLicenses").getParameters().get("licenseGroupIds"), groupId.toString()));
        }
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<License>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerUserAssignedLicenses").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()), parameters);
    }
}

