/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.customerusers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.customerusers.CustomerUserLicenseCollectionOperations;
import com.microsoft.store.partnercenter.customerusers.CustomerUserLicenseUpdateOperations;
import com.microsoft.store.partnercenter.customerusers.CustomerUserRoleCollectionOperations;
import com.microsoft.store.partnercenter.customerusers.ICustomerUser;
import com.microsoft.store.partnercenter.customerusers.ICustomerUserLicenseCollection;
import com.microsoft.store.partnercenter.customerusers.ICustomerUserLicenseUpdates;
import com.microsoft.store.partnercenter.customerusers.ICustomerUserRoleCollection;
import com.microsoft.store.partnercenter.models.users.CustomerUser;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class CustomerUserOperations
extends BasePartnerComponent<Tuple<String, String>>
implements ICustomerUser {
    private ICustomerUserRoleCollection customerUserDirectoryRoleCollectionOperations;
    private ICustomerUserLicenseCollection customerUserLicenseCollectionOperations;
    private ICustomerUserLicenseUpdates customerUserLicenseUpdateOperations;

    public CustomerUserOperations(IPartner rootPartnerOperations, String customerId, String userId) {
        super(rootPartnerOperations, new Tuple<String, String>(customerId, userId));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(userId)) {
            throw new IllegalArgumentException("userId must be set");
        }
    }

    @Override
    public CustomerUser get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<CustomerUser>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerUserDetails").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()));
    }

    @Override
    public void delete() {
        this.getPartner().getServiceClient().delete(this.getPartner(), new TypeReference<CustomerUser>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("DeleteCustomerUser").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()));
    }

    @Override
    public CustomerUser patch(CustomerUser customerUser) {
        if (customerUser == null) {
            throw new IllegalArgumentException("customerUser cannot be null");
        }
        return this.getPartner().getServiceClient().patch(this.getPartner(), new TypeReference<CustomerUser>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("UpdateCustomerUser").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()), customerUser);
    }

    @Override
    public ICustomerUserRoleCollection getDirectoryRoles() {
        if (this.customerUserDirectoryRoleCollectionOperations == null) {
            this.customerUserDirectoryRoleCollectionOperations = new CustomerUserRoleCollectionOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2());
        }
        return this.customerUserDirectoryRoleCollectionOperations;
    }

    @Override
    public ICustomerUserLicenseCollection getLicenses() {
        if (this.customerUserLicenseCollectionOperations == null) {
            this.customerUserLicenseCollectionOperations = new CustomerUserLicenseCollectionOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2());
        }
        return this.customerUserLicenseCollectionOperations;
    }

    @Override
    public ICustomerUserLicenseUpdates getLicenseUpdates() {
        if (this.customerUserLicenseUpdateOperations == null) {
            this.customerUserLicenseUpdateOperations = new CustomerUserLicenseUpdateOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2());
        }
        return this.customerUserLicenseUpdateOperations;
    }
}

