/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.customerusers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.customerusers.CustomerUserOperations;
import com.microsoft.store.partnercenter.customerusers.ICustomerUser;
import com.microsoft.store.partnercenter.customerusers.ICustomerUserCollection;
import com.microsoft.store.partnercenter.exception.PartnerErrorCategory;
import com.microsoft.store.partnercenter.exception.PartnerException;
import com.microsoft.store.partnercenter.models.SeekBasedResourceCollection;
import com.microsoft.store.partnercenter.models.query.IQuery;
import com.microsoft.store.partnercenter.models.query.QueryType;
import com.microsoft.store.partnercenter.models.users.CustomerUser;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;

public class CustomerUsersCollectionOperations
extends BasePartnerComponent<String>
implements ICustomerUserCollection {
    public CustomerUsersCollectionOperations(IPartner rootPartnerOperations, String customerId) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
    }

    @Override
    public CustomerUser create(CustomerUser newCustomerUser) {
        if (newCustomerUser == null) {
            throw new IllegalArgumentException("The newCustomerUser parameter cannot be null.");
        }
        return this.getPartner().getServiceClient().post(this.getPartner(), new TypeReference<CustomerUser>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("CreateCustomerUser").getPath(), this.getContext()), newCustomerUser);
    }

    @Override
    public SeekBasedResourceCollection<CustomerUser> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<SeekBasedResourceCollection<CustomerUser>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerUsers").getPath(), this.getContext()));
    }

    @Override
    public ICustomerUser byId(String userId) {
        return new CustomerUserOperations(this.getPartner(), (String)this.getContext(), userId);
    }

    @Override
    public SeekBasedResourceCollection<CustomerUser> query(IQuery customerUsersQuery) {
        if (customerUsersQuery == null) {
            throw new IllegalArgumentException("customerUsersQuery can't be null");
        }
        if (customerUsersQuery.getType() == QueryType.COUNT) {
            throw new IllegalArgumentException("customerUsersQuery can't be a count query.");
        }
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (customerUsersQuery.getType() == QueryType.SEEK) {
            if (customerUsersQuery.getToken() == null) {
                throw new IllegalArgumentException("customerUsersQuery.Token is required.");
            }
            headers.put(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerUsers").getAdditionalHeaders().get("ContinuationToken"), customerUsersQuery.getToken().toString());
            parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerUsers").getParameters().get("SeekOperation"), customerUsersQuery.getSeekOperation().toString()));
        } else {
            if (customerUsersQuery.getType() == QueryType.INDEXED) {
                parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerUsers").getParameters().get("Size"), String.valueOf(customerUsersQuery.getPageSize())));
            } else {
                parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerUsers").getParameters().get("Size"), "0"));
            }
            if (customerUsersQuery.getFilter() != null) {
                ObjectMapper mapper = new ObjectMapper();
                try {
                    parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerUsers").getParameters().get("Filter"), URLEncoder.encode(mapper.writeValueAsString((Object)customerUsersQuery.getFilter()), "UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new PartnerException("", null, PartnerErrorCategory.REQUEST_PARSING, (Exception)e);
                }
                catch (JsonProcessingException e) {
                    throw new PartnerException("", null, PartnerErrorCategory.REQUEST_PARSING, (Exception)((Object)e));
                }
            }
            if (customerUsersQuery.getSort() != null) {
                parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerUsers").getParameters().get("SortField"), customerUsersQuery.getSort().getSortField()));
                parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerUsers").getParameters().get("SortDirection"), customerUsersQuery.getSort().getSortDirection().toString()));
            }
        }
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<SeekBasedResourceCollection<CustomerUser>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetCustomerUsers").getPath(), this.getContext()), headers, parameters);
    }
}

