/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.devicesdeployment;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.devicesdeployment.ConfigurationPolicyOperations;
import com.microsoft.store.partnercenter.devicesdeployment.IConfigurationPolicy;
import com.microsoft.store.partnercenter.devicesdeployment.IConfigurationPolicyCollection;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.devicesdeployment.ConfigurationPolicy;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class ConfigurationPolicyCollectionOperations
extends BasePartnerComponentString
implements IConfigurationPolicyCollection {
    public ConfigurationPolicyCollectionOperations(IPartner rootPartnerOperations, String customerId) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
    }

    @Override
    public IConfigurationPolicy byId(String policyId) {
        return new ConfigurationPolicyOperations(this.getPartner(), (String)this.getContext(), policyId);
    }

    @Override
    public ConfigurationPolicy create(ConfigurationPolicy newPolicy) {
        if (newPolicy == null) {
            throw new IllegalArgumentException("The newPolicy parameter cannot be null");
        }
        return this.getPartner().getServiceClient().post(this.getPartner(), new TypeReference<ConfigurationPolicy>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("CreateConfigurationPolicy").getPath(), this.getContext()), newPolicy);
    }

    @Override
    public ResourceCollection<ConfigurationPolicy> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<ConfigurationPolicy>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetConfigurationPolicies").getPath(), this.getContext()));
    }
}

