/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.devicesdeployment;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.devicesdeployment.IConfigurationPolicy;
import com.microsoft.store.partnercenter.models.devicesdeployment.ConfigurationPolicy;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class ConfigurationPolicyOperations
extends BasePartnerComponent<Tuple<String, String>>
implements IConfigurationPolicy {
    public ConfigurationPolicyOperations(IPartner rootPartnerOperations, String customerId, String policyId) {
        super(rootPartnerOperations, new Tuple<String, String>(customerId, policyId));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(policyId)) {
            throw new IllegalArgumentException("policyId must be set");
        }
    }

    @Override
    public ConfigurationPolicy get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ConfigurationPolicy>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetConfigurationPolicy").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()));
    }

    @Override
    public ConfigurationPolicy patch(ConfigurationPolicy policy) {
        return this.getPartner().getServiceClient().put(this.getPartner(), new TypeReference<ConfigurationPolicy>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("UpdateConfigurationPolicy").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()), policy);
    }

    @Override
    public void delete() {
        this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ConfigurationPolicy>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("DeleteConfigurationPolicy").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()));
    }
}

