/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.devicesdeployment;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.devicesdeployment.DeviceOperations;
import com.microsoft.store.partnercenter.devicesdeployment.IDevice;
import com.microsoft.store.partnercenter.devicesdeployment.IDeviceCollection;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.devicesdeployment.Device;
import com.microsoft.store.partnercenter.models.utils.Tuple;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.List;
import okhttp3.Response;

public class DeviceCollectionOperations
extends BasePartnerComponent<Tuple<String, String>>
implements IDeviceCollection {
    public DeviceCollectionOperations(IPartner rootPartnerOperations, String customerId, String deviceBatchId) {
        super(rootPartnerOperations, new Tuple<String, String>(customerId, deviceBatchId));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(deviceBatchId)) {
            throw new IllegalArgumentException("deviceBatchId must be set");
        }
    }

    @Override
    public IDevice byId(String deviceId) {
        return new DeviceOperations(this.getPartner(), (String)((Tuple)this.getContext()).getItem1(), (String)((Tuple)this.getContext()).getItem2(), deviceId);
    }

    @Override
    public String create(List<Device> newDevices) {
        Response response = this.getPartner().getServiceClient().post(this.getPartner(), new TypeReference<Response>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("AddDevicestoDeviceBatch").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()), newDevices);
        return response.header("location");
    }

    @Override
    public ResourceCollection<Device> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Device>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetDevices").getPath(), ((Tuple)this.getContext()).getItem1(), ((Tuple)this.getContext()).getItem2()));
    }
}

