/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.devicesdeployment;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponent;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.devicesdeployment.IDevice;
import com.microsoft.store.partnercenter.models.devicesdeployment.ConfigurationPolicy;
import com.microsoft.store.partnercenter.models.devicesdeployment.Device;
import com.microsoft.store.partnercenter.models.utils.TripletTuple;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;

public class DeviceOperations
extends BasePartnerComponent<TripletTuple<String, String, String>>
implements IDevice {
    public DeviceOperations(IPartner rootPartnerOperations, String customerId, String deviceBatchId, String deviceId) {
        super(rootPartnerOperations, new TripletTuple<String, String, String>(customerId, deviceBatchId, deviceId));
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(deviceBatchId)) {
            throw new IllegalArgumentException("deviceBatchId must be set");
        }
        if (StringHelper.isNullOrWhiteSpace(deviceId)) {
            throw new IllegalArgumentException("deviceId must be set");
        }
    }

    @Override
    public Device patch(Device updateDevice) {
        return this.getPartner().getServiceClient().put(this.getPartner(), new TypeReference<Device>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("UpdateDevice").getPath(), ((TripletTuple)this.getContext()).getItem1(), ((TripletTuple)this.getContext()).getItem2()), updateDevice);
    }

    @Override
    public void delete() {
        this.getPartner().getServiceClient().delete(this.getPartner(), new TypeReference<ConfigurationPolicy>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("DeleteDevice").getPath(), ((TripletTuple)this.getContext()).getItem1(), ((TripletTuple)this.getContext()).getItem2(), ((TripletTuple)this.getContext()).getItem3()));
    }
}

