/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.devicesdeployment;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.devicesdeployment.DevicesBatchOperations;
import com.microsoft.store.partnercenter.devicesdeployment.IDevicesBatch;
import com.microsoft.store.partnercenter.devicesdeployment.IDevicesBatchCollection;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.devicesdeployment.DeviceBatch;
import com.microsoft.store.partnercenter.models.devicesdeployment.DeviceBatchCreationRequest;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import okhttp3.Response;

public class DevicesBatchCollectionOperations
extends BasePartnerComponentString
implements IDevicesBatchCollection {
    public DevicesBatchCollectionOperations(IPartner rootPartnerOperations, String customerId) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
    }

    @Override
    public IDevicesBatch byId(String deviceBatchId) {
        return new DevicesBatchOperations(this.getPartner(), (String)this.getContext(), deviceBatchId);
    }

    @Override
    public String create(DeviceBatchCreationRequest newDeviceBatch) {
        Response response = this.getPartner().getServiceClient().post(this.getPartner(), new TypeReference<Response>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("CreateDeviceBatch").getPath(), this.getContext()), newDeviceBatch);
        return response.header("location");
    }

    @Override
    public ResourceCollection<DeviceBatch> get() {
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<DeviceBatch>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetDeviceBatches").getPath(), this.getContext()));
    }
}

