/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.domains;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.domains.IDomain;
import com.microsoft.store.partnercenter.exception.PartnerErrorCategory;
import com.microsoft.store.partnercenter.exception.PartnerException;
import java.text.MessageFormat;

public class DomainOperations
extends BasePartnerComponentString
implements IDomain {
    protected DomainOperations(IPartner rootPartnerOperations, String domain) {
        super(rootPartnerOperations, domain);
        if (domain == null || domain.trim().isEmpty()) {
            throw new IllegalArgumentException("Domain string cannot be null or empty");
        }
    }

    @Override
    public boolean exists() {
        try {
            this.getPartner().getServiceClient().head(this.getPartner(), new TypeReference<String>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("CheckDomainAvailability").getPath(), this.getContext()));
        }
        catch (PartnerException ex) {
            if (ex.getErrorCategory().equals((Object)PartnerErrorCategory.NOT_FOUND)) {
                return false;
            }
            throw ex;
        }
        return true;
    }
}

