/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.entitlements;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.PartnerService;
import com.microsoft.store.partnercenter.entitlements.EntitlementCollectionByEntitlementTypeOperations;
import com.microsoft.store.partnercenter.entitlements.IEntitlementCollection;
import com.microsoft.store.partnercenter.genericoperations.IEntireEntityCollectionRetrievalOperations;
import com.microsoft.store.partnercenter.models.ResourceCollection;
import com.microsoft.store.partnercenter.models.entitlements.Entitlement;
import com.microsoft.store.partnercenter.models.utils.KeyValuePair;
import com.microsoft.store.partnercenter.utils.StringHelper;
import java.text.MessageFormat;
import java.util.ArrayList;

public class EntitlementCollectionOperations
extends BasePartnerComponentString
implements IEntitlementCollection {
    public EntitlementCollectionOperations(IPartner rootPartnerOperations, String customerId) {
        super(rootPartnerOperations, customerId);
        if (StringHelper.isNullOrWhiteSpace(customerId)) {
            throw new IllegalArgumentException("customerId must be set");
        }
    }

    @Override
    public IEntireEntityCollectionRetrievalOperations<Entitlement, ResourceCollection<Entitlement>> byEntitlementType(String entitlementType) {
        return new EntitlementCollectionByEntitlementTypeOperations(this.getPartner(), (String)this.getContext(), entitlementType);
    }

    @Override
    public ResourceCollection<Entitlement> get() {
        return this.get(false);
    }

    @Override
    public ResourceCollection<Entitlement> get(Boolean showExpiry) {
        ArrayList<KeyValuePair<String, String>> parameters = new ArrayList<KeyValuePair<String, String>>();
        parameters.add(new KeyValuePair<String, String>(PartnerService.getInstance().getConfiguration().getApis().get("GetEntitlements").getParameters().get("ShowExpiry"), String.valueOf(showExpiry)));
        return this.getPartner().getServiceClient().get(this.getPartner(), new TypeReference<ResourceCollection<Entitlement>>(){}, MessageFormat.format(PartnerService.getInstance().getConfiguration().getApis().get("GetEntitlements").getPath(), this.getContext()), parameters);
    }
}

