/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.store.partnercenter.enumerators;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.store.partnercenter.BasePartnerComponentString;
import com.microsoft.store.partnercenter.IPartner;
import com.microsoft.store.partnercenter.enumerators.IResourceCollectionEnumerator;
import com.microsoft.store.partnercenter.models.ResourceBaseWithLinks;
import com.microsoft.store.partnercenter.models.StandardResourceCollectionLinks;
import com.microsoft.store.partnercenter.requestcontext.IRequestContext;

public abstract class BaseResourceCollectionEnumerator<T extends ResourceBaseWithLinks<StandardResourceCollectionLinks>>
extends BasePartnerComponentString
implements IResourceCollectionEnumerator<T> {
    private TypeReference<T> responseType;
    private T resourceCollection = null;

    protected BaseResourceCollectionEnumerator(IPartner rootPartnerOperations, T resourceCollection, ObjectMapper resourceCollectionConverter, TypeReference<T> responseType) {
        super(rootPartnerOperations);
        if (resourceCollection == null) {
            throw new IllegalArgumentException("resourceCollection null");
        }
        this.resourceCollection = resourceCollection;
        this.responseType = responseType;
    }

    @Override
    public boolean isFirstPage() {
        if (!this.hasValue()) {
            throw new UnsupportedOperationException("The enumerator does not have a current value");
        }
        return ((ResourceBaseWithLinks)this.getCurrent()).getLinks() == null || ((StandardResourceCollectionLinks)((ResourceBaseWithLinks)this.getCurrent()).getLinks()).getPrevious() == null;
    }

    @Override
    public boolean isLastPage() {
        if (!this.hasValue()) {
            throw new UnsupportedOperationException("The enumerator does not have a current value");
        }
        return ((ResourceBaseWithLinks)this.getCurrent()).getLinks() == null || ((StandardResourceCollectionLinks)((ResourceBaseWithLinks)this.getCurrent()).getLinks()).getNext() == null;
    }

    @Override
    public boolean hasValue() {
        return this.resourceCollection != null;
    }

    @Override
    public T getCurrent() {
        return this.resourceCollection;
    }

    @Override
    public void next() {
        this.next(null);
    }

    @Override
    public void next(IRequestContext context) {
        if (!this.hasValue()) {
            throw new UnsupportedOperationException("The enumerator does not have a current value");
        }
        this.resourceCollection = this.isLastPage() ? null : (ResourceBaseWithLinks)this.getPartner().getServiceClient().get(this.getPartner(), this.responseType, ((StandardResourceCollectionLinks)((ResourceBaseWithLinks)this.resourceCollection).getLinks()).getNext());
    }

    @Override
    public void previous() {
        this.previous(null);
    }

    @Override
    public void previous(IRequestContext context) {
        if (!this.hasValue()) {
            throw new UnsupportedOperationException("The enumerator does not have a current value");
        }
        this.resourceCollection = this.isFirstPage() ? null : (ResourceBaseWithLinks)this.getPartner().getServiceClient().get(this.getPartner(), this.responseType, ((StandardResourceCollectionLinks)((ResourceBaseWithLinks)this.resourceCollection).getLinks()).getPrevious());
    }
}

